/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.rest.AbstractInjectionResource;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiView;

@Path(value="/")
public class MainModuleResource
extends AbstractInjectionResource {
    private static final String MAIN_JS = "onos.js";
    private static final String INJECT_VIEW_IDS_START = "// {INJECTED-VIEW-DATA-START}";
    private static final String INJECT_VIEW_IDS_END = "// {INJECTED-VIEW-DATA-END}";
    private static final String PREFIX = "        '";
    private static final String MIDFIX = "' : '";
    private static final String SUFFIX = String.format("',%n", new Object[0]);

    @GET
    @Produces(value={"text/javascript"})
    public Response getMainModule() throws IOException {
        UiExtensionService service = (UiExtensionService)this.get(UiExtensionService.class);
        InputStream jsTemplate = this.getClass().getClassLoader().getResourceAsStream(MAIN_JS);
        String js = new String(ByteStreams.toByteArray((InputStream)jsTemplate));
        int p1s = this.split(js, 0, INJECT_VIEW_IDS_START) - INJECT_VIEW_IDS_START.length();
        int p1e = this.split(js, 0, INJECT_VIEW_IDS_END);
        int p2s = this.split(js, p1e, null);
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(js, 0, p1s), (Object)this.includeViewIds(service), (Object)this.stream(js, p1e, p2s)));
        return Response.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).build();
    }

    private InputStream includeViewIds(UiExtensionService service) {
        StringBuilder sb = new StringBuilder("\n");
        for (UiExtension extension : service.getExtensions()) {
            for (UiView view : extension.views()) {
                sb.append(PREFIX).append(view.id()).append(MIDFIX).append(this.sanitizeUrl(view.helpPageUrl())).append(SUFFIX);
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private String sanitizeUrl(String url) {
        return url;
    }
}

