/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.rest.AbstractInjectionResource;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiPreferencesService;
import org.onosproject.ui.UiSessionToken;
import org.onosproject.ui.UiTokenService;
import org.onosproject.ui.impl.MainIndexResource;

@Path(value="/")
public class MainIndexResource
extends AbstractInjectionResource {
    private static final String INDEX = "index.html";
    private static final String NOT_READY = "not-ready.html";
    private static final String INJECT_USER_START = "<!-- {INJECTED-USER-START} -->";
    private static final String INJECT_USER_END = "<!-- {INJECTED-USER-END} -->";
    private static final String INJECT_CSS_START = "<!-- {INJECTED-STYLESHEETS-START} -->";
    private static final String INJECT_CSS_END = "<!-- {INJECTED-STYLESHEETS-END} -->";
    private static final String INJECT_JS_START = "<!-- {INJECTED-JAVASCRIPT-START} -->";
    private static final String INJECT_JS_END = "<!-- {INJECTED-JAVASCRIPT-END} -->";
    private static final byte[] SCRIPT_START = "\n<script>\n".getBytes();
    private static final byte[] SCRIPT_END = "</script>\n\n".getBytes();
    @Context
    private SecurityContext ctx;
    private static final String NL = String.format("%n", new Object[0]);
    private static final byte[] NL_BYTES = NL.getBytes();

    @GET
    @Produces(value={"text/html"})
    public Response getMainIndex() throws IOException {
        UiTokenService tokens;
        UiExtensionService service;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            service = (UiExtensionService)this.get(UiExtensionService.class);
            tokens = (UiTokenService)this.get(UiTokenService.class);
        }
        catch (ServiceNotFoundException e) {
            return Response.ok((Object)classLoader.getResourceAsStream(NOT_READY)).build();
        }
        InputStream indexTemplate = classLoader.getResourceAsStream(INDEX);
        String index = new String(ByteStreams.toByteArray((InputStream)indexTemplate));
        int p0s = this.split(index, 0, INJECT_USER_START) - INJECT_USER_START.length();
        int p0e = this.split(index, p0s, INJECT_USER_END);
        int p1s = this.split(index, p0e, INJECT_JS_START) - INJECT_JS_START.length();
        int p1e = this.split(index, p1s, INJECT_JS_END);
        int p2s = this.split(index, p1e, INJECT_CSS_START) - INJECT_CSS_START.length();
        int p2e = this.split(index, p2s, INJECT_CSS_END);
        int p3s = this.split(index, p2e, null);
        String userName = this.ctx.getUserPrincipal().getName();
        UiSessionToken token = tokens.issueToken(userName);
        String auth = "var onosUser='" + userName + "',\n    onosAuth='" + token + "';\n";
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(index, 0, p0s), (Object)new ByteArrayInputStream(SCRIPT_START), (Object)this.stream(auth, 0, auth.length()), (Object)this.userPreferences(userName), (Object)this.userConsoleLog(userName), (Object)new ByteArrayInputStream(SCRIPT_END), (Object)this.stream(index, p0e, p1s), (Object)this.includeJs(service), (Object)this.stream(index, p1e, p2s), (Object)this.includeCss(service), (Object)this.stream(index, p2e, p3s)));
        return Response.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).build();
    }

    private InputStream userConsoleLog(String userName) {
        String code = "console.log('Logging in as user >" + userName + "<');\n";
        return new ByteArrayInputStream(code.getBytes());
    }

    private InputStream userPreferences(String userName) {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        ObjectNode prefs = this.mapper().createObjectNode();
        service.getPreferences(userName).forEach((arg_0, arg_1) -> ((ObjectNode)prefs).set(arg_0, arg_1));
        String string = "var userPrefs = " + prefs.toString() + ";\n";
        return new ByteArrayInputStream(string.getBytes());
    }

    private InputStream includeJs(UiExtensionService service) {
        ImmutableList.Builder builder = ImmutableList.builder();
        service.getExtensions().forEach(ext -> {
            this.add(builder, ext.js());
            this.add(builder, (InputStream)new NewlineInputStream(null));
        });
        return new SequenceInputStream((Enumeration<? extends InputStream>)new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)builder.build()));
    }

    private InputStream includeCss(UiExtensionService service) {
        ImmutableList.Builder builder = ImmutableList.builder();
        service.getExtensions().forEach(ext -> {
            this.add(builder, ext.css());
            this.add(builder, (InputStream)new NewlineInputStream(null));
        });
        return new SequenceInputStream((Enumeration<? extends InputStream>)new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)builder.build()));
    }

    private void add(ImmutableList.Builder<InputStream> builder, InputStream inputStream) {
        if (inputStream != null) {
            builder.add((Object)inputStream);
        }
    }

    static /* synthetic */ byte[] access$000() {
        return NL_BYTES;
    }
}

