/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf;

import com.google.common.annotations.Beta;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onosproject.netconf.DatastoreId;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.TargetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NetconfSession {
    @Deprecated
    public CompletableFuture<String> request(String var1) throws NetconfException;

    public String get(String var1) throws NetconfException;

    public String get(String var1, String var2) throws NetconfException;

    public String doWrappedRpc(String var1) throws NetconfException;

    public String requestSync(String var1) throws NetconfException;

    default public String getConfig(DatastoreId netconfTargetConfig) throws NetconfException {
        return this.getConfig((String)netconfTargetConfig.id());
    }

    @Deprecated
    default public String getConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        return this.getConfig(TargetConfig.toDatastoreId(netconfTargetConfig));
    }

    @Deprecated
    default public String getConfig(String netconfTargetConfig) throws NetconfException {
        return this.getConfig(TargetConfig.toDatastoreId(netconfTargetConfig));
    }

    default public String getConfig(DatastoreId netconfTargetConfig, String configurationFilterSchema) throws NetconfException {
        return this.getConfig((String)netconfTargetConfig.id(), configurationFilterSchema);
    }

    @Deprecated
    default public String getConfig(String netconfTargetConfig, String configurationFilterSchema) throws NetconfException {
        return this.getConfig(TargetConfig.toDatastoreId(netconfTargetConfig), configurationFilterSchema);
    }

    @Deprecated
    default public String getConfig(TargetConfig netconfTargetConfig, String configurationFilterSchema) throws NetconfException {
        return this.getConfig(TargetConfig.toDatastoreId(netconfTargetConfig), configurationFilterSchema);
    }

    public boolean editConfig(String var1) throws NetconfException;

    default public boolean editConfig(DatastoreId netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        return this.editConfig((String)netconfTargetConfig.id(), mode, newConfiguration);
    }

    @Deprecated
    default public boolean editConfig(String netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        return this.editConfig(TargetConfig.toDatastoreId(netconfTargetConfig), mode, newConfiguration);
    }

    @Deprecated
    default public boolean editConfig(TargetConfig netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        return this.editConfig(TargetConfig.toDatastoreId(netconfTargetConfig), mode, newConfiguration);
    }

    default public boolean copyConfig(DatastoreId destination, DatastoreId source) throws NetconfException {
        return this.copyConfig((String)destination.id(), (String)source.id());
    }

    default public boolean copyConfig(DatastoreId netconfTargetConfig, String newConfiguration) throws NetconfException {
        return this.copyConfig((String)netconfTargetConfig.id(), newConfiguration);
    }

    public boolean copyConfig(String var1, String var2) throws NetconfException;

    @Deprecated
    default public boolean copyConfig(TargetConfig netconfTargetConfig, String newConfiguration) throws NetconfException {
        return this.copyConfig(TargetConfig.toDatastoreId(netconfTargetConfig), newConfiguration);
    }

    default public boolean deleteConfig(DatastoreId netconfTargetConfig) throws NetconfException {
        return this.deleteConfig((String)netconfTargetConfig.id());
    }

    @Deprecated
    default public boolean deleteConfig(String netconfTargetConfig) throws NetconfException {
        return this.deleteConfig(TargetConfig.toDatastoreId(netconfTargetConfig));
    }

    @Deprecated
    default public boolean deleteConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        return this.deleteConfig(TargetConfig.toDatastoreId(netconfTargetConfig));
    }

    public void startSubscription() throws NetconfException;

    @Beta
    public void startSubscription(String var1) throws NetconfException;

    public void endSubscription() throws NetconfException;

    default public boolean lock(DatastoreId datastore) throws NetconfException {
        return this.lock((String)datastore.id());
    }

    @Deprecated
    default public boolean lock(String configType) throws NetconfException {
        return this.lock(TargetConfig.toDatastoreId(configType));
    }

    default public boolean unlock(DatastoreId datastore) throws NetconfException {
        return this.unlock((String)datastore.id());
    }

    @Deprecated
    default public boolean unlock(String configType) throws NetconfException {
        return this.unlock(TargetConfig.toDatastoreId(configType));
    }

    default public boolean lock() throws NetconfException {
        return this.lock(DatastoreId.RUNNING);
    }

    default public boolean unlock() throws NetconfException {
        return this.unlock(DatastoreId.RUNNING);
    }

    public boolean close() throws NetconfException;

    public String getSessionId();

    default public Set<String> getDeviceCapabilitiesSet() {
        LinkedHashSet<String> capabilities = new LinkedHashSet<String>();
        Matcher capabilityMatcher = Pattern.compile("<capability>\\s*(.*?)\\s*</capability>").matcher(this.getServerCapabilities());
        while (capabilityMatcher.find()) {
            capabilities.add(capabilityMatcher.group(1));
        }
        return capabilities;
    }

    @Deprecated
    public String getServerCapabilities();

    @Deprecated
    public void setDeviceCapabilities(List<String> var1);

    default public void checkAndReestablish() throws NetconfException {
        Logger log = LoggerFactory.getLogger(NetconfSession.class);
        log.error("Not implemented/exposed by the underlying session implementation");
    }

    default public void setOnosCapabilities(Iterable<String> capabilities) {
    }

    public void addDeviceOutputListener(NetconfDeviceOutputEventListener var1);

    public void removeDeviceOutputListener(NetconfDeviceOutputEventListener var1);
}

