/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceInfo {
    public static final Logger log = LoggerFactory.getLogger(NetconfDeviceInfo.class);
    private String name;
    private String password;
    private IpAddress ipAddress;
    private int port;
    private char[] key;
    @Deprecated
    private File keyFile;
    private DeviceId deviceId;

    public NetconfDeviceInfo(String name, String password, IpAddress ipAddress, int port) {
        Preconditions.checkArgument((!name.equals("") ? 1 : 0) != 0, (Object)"Empty device username");
        Preconditions.checkNotNull((Object)(port > 0 ? 1 : 0), (Object)"Negative port");
        Preconditions.checkNotNull((Object)ipAddress, (Object)"Null ip address");
        this.name = name;
        this.password = password;
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public NetconfDeviceInfo(String name, String password, IpAddress ipAddress, int port, String keyString) {
        Preconditions.checkArgument((!name.equals("") ? 1 : 0) != 0, (Object)"Empty device name");
        Preconditions.checkNotNull((Object)(port > 0 ? 1 : 0), (Object)"Negative port");
        Preconditions.checkNotNull((Object)ipAddress, (Object)"Null ip address");
        this.name = name;
        this.password = password;
        this.ipAddress = ipAddress;
        this.port = port;
        this.key = keyString.toCharArray();
        this.keyFile = new File(keyString);
    }

    public String name() {
        return this.name;
    }

    public String password() {
        return this.password;
    }

    public IpAddress ip() {
        return this.ipAddress;
    }

    public int port() {
        return this.port;
    }

    public char[] getKey() {
        return this.key;
    }

    @Deprecated
    public File getKeyFile() {
        return this.keyFile;
    }

    public String toString() {
        return "netconf:" + this.name + "@" + this.ipAddress + ":" + this.port;
    }

    public DeviceId getDeviceId() {
        if (this.deviceId == null) {
            try {
                this.deviceId = DeviceId.deviceId((URI)new URI("netconf", this.ipAddress.toString() + ":" + this.port, null));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to build deviceID for device " + this.toString(), e);
            }
        }
        return this.deviceId;
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.port, this.name);
    }

    public boolean equals(Object toBeCompared) {
        NetconfDeviceInfo netconfDeviceInfo;
        return toBeCompared instanceof NetconfDeviceInfo && (netconfDeviceInfo = (NetconfDeviceInfo)toBeCompared).name().equals(this.name) && netconfDeviceInfo.ip().equals((Object)this.ipAddress) && netconfDeviceInfo.port() == this.port && netconfDeviceInfo.password().equals(this.password);
    }
}

