/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf;

import com.google.common.base.Preconditions;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringNetconfDeviceOutputEventListener
implements NetconfDeviceOutputEventListener {
    private static final Logger log = LoggerFactory.getLogger(FilteringNetconfDeviceOutputEventListener.class);
    private final NetconfDeviceInfo deviceInfo;

    public FilteringNetconfDeviceOutputEventListener(NetconfDeviceInfo deviceInfo) {
        this.deviceInfo = (NetconfDeviceInfo)Preconditions.checkNotNull((Object)deviceInfo);
    }

    public void event(NetconfDeviceOutputEvent event) {
        switch ((NetconfDeviceOutputEvent.Type)event.type()) {
            case DEVICE_REPLY: {
                log.debug("Device {} has reply: {}", (Object)this.deviceInfo, (Object)event.getMessagePayload());
                break;
            }
            case DEVICE_NOTIFICATION: {
                log.info("Device {} has notification: {}", (Object)this.deviceInfo, (Object)event.getMessagePayload());
                break;
            }
            case DEVICE_UNREGISTERED: {
                log.warn("Device {} has closed session", (Object)this.deviceInfo);
                break;
            }
            case DEVICE_ERROR: {
                log.warn("Device {} has error: {}", (Object)this.deviceInfo, (Object)event.getMessagePayload());
                break;
            }
            case SESSION_CLOSED: {
                log.warn("Device {} has closed Session: {}", (Object)this.deviceInfo, (Object)event.getMessagePayload());
                break;
            }
            default: {
                log.warn("Wrong event type {} ", (Object)event.type());
            }
        }
    }

    public boolean isRelevant(NetconfDeviceOutputEvent event) {
        return this.deviceInfo.equals(event.getDeviceInfo());
    }
}

