/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ytb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.tojava.javamodel.JavaLeafInfoContainer;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.onosproject.yms.app.utils.TraversalType;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.app.ytb.YtbException;
import org.onosproject.yms.app.ytb.YtbNodeInfo;
import org.onosproject.yms.ydt.YdtContextOperationType;

public final class YtbUtil {
    public static final String STR_NULL = "null";
    public static final String PERIOD = ".";
    private static final int ONE = 1;
    private static final String YANG = "yang";
    private static final String OP_TYPE = "OpType";
    private static final String STR_NONE = "NONE";
    private static final String ENUM_LEAF_IDENTIFIER = "$LeafIdentifier";
    private static final Set<YangDataTypes> PRIMITIVE_TYPES = new HashSet<YangDataTypes>(Arrays.asList(YangDataTypes.INT8, YangDataTypes.INT16, YangDataTypes.INT32, YangDataTypes.INT64, YangDataTypes.UINT8, YangDataTypes.UINT16, YangDataTypes.UINT32, YangDataTypes.BOOLEAN, YangDataTypes.EMPTY));
    private static final String TO_STRING = "toString";

    private YtbUtil() {
    }

    public static Object getParentObjectOfNode(YtbNodeInfo nodeInfo, YangNode yangNode) {
        Object object = yangNode instanceof YangCase ? nodeInfo.getCaseObject() : (yangNode instanceof YangAugment ? nodeInfo.getAugmentObject() : nodeInfo.getYangObject());
        return object;
    }

    public static Object getAttributeOfObject(Object nodeObj, String fieldName) throws NoSuchMethodException {
        Class<?> nodeClass = nodeObj.getClass();
        try {
            Method getterMethod = nodeClass.getDeclaredMethod(fieldName, new Class[0]);
            return getterMethod.invoke(nodeObj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new YtbException(e);
        }
    }

    public static Object getAttributeFromInheritance(Object childClass, String methodName) {
        Class<?> parentClass = childClass.getClass().getSuperclass();
        try {
            Method getterMethod = parentClass.getDeclaredMethod(methodName, new Class[0]);
            return getterMethod.invoke(childClass, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new YtbException(e);
        }
    }

    public static Class<?> getInterfaceClassFromImplClass(Object obj) {
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if (interfaces.length > 1) {
            throw new YtbException("Implementation class having more than one interface is not handled");
        }
        return interfaces[0];
    }

    public static YdtContextOperationType getNodeOpType(Object nodeObj, String typeName) {
        Object opTypeObj;
        try {
            opTypeObj = YtbUtil.getAttributeOfObject(nodeObj, typeName);
        }
        catch (NoSuchMethodException e) {
            return YdtContextOperationType.valueOf((String)STR_NONE);
        }
        String opTypeValue = String.valueOf(opTypeObj);
        if (opTypeValue.equals(STR_NULL)) {
            return null;
        }
        return YdtContextOperationType.valueOf((String)opTypeValue);
    }

    public static boolean isTypePrimitive(YangType yangType) {
        if (yangType.getDataType() == YangDataTypes.LEAFREF) {
            YangLeafRef leafRef = (YangLeafRef)yangType.getDataTypeExtendedInfo();
            return YtbUtil.isPrimitiveDataType(leafRef.getEffectiveDataType().getDataType());
        }
        return YtbUtil.isPrimitiveDataType(yangType.getDataType());
    }

    public static Class<?> getClassLoaderForAugment(YangNode curNode, YangSchemaRegistry registry) {
        YangNode moduleNode = curNode.getParent();
        String moduleName = moduleNode.getJavaClassNameOrBuiltInType();
        String modulePackage = moduleNode.getJavaPackage();
        return registry.getRegisteredClass((YangSchemaNode)moduleNode);
    }

    public static String isValueOrSelectLeafSet(YangSchemaNode holder, Object nodeObj, String javaName, String methodName) throws NoSuchMethodException {
        Class<?> nodeClass = nodeObj.getClass();
        String enumPackage = holder.getJavaPackage() + PERIOD + YangIoUtils.getCapitalCase((String)holder.getJavaClassNameOrBuiltInType()) + ENUM_LEAF_IDENTIFIER;
        ClassLoader classLoader = nodeClass.getClassLoader();
        try {
            Class<?> leafEnum = classLoader.loadClass(enumPackage);
            Method getterMethod = nodeClass.getMethod(methodName, leafEnum);
            Object value = Enum.valueOf(leafEnum, javaName.toUpperCase());
            return String.valueOf(getterMethod.invoke(nodeObj, value));
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new YtbException(e);
        }
    }

    public static String getStringFromType(YangSchemaNode holder, Object holderObj, String name, Object fieldObj, YangType dataType) {
        if (fieldObj == null) {
            throw new YtbException("Value of " + holder.getName() + " is null");
        }
        YangDataTypes type = dataType.getDataType();
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UINT8: 
            case UINT16: 
            case UINT32: 
            case UINT64: 
            case EMPTY: 
            case STRING: 
            case DECIMAL64: 
            case INSTANCE_IDENTIFIER: 
            case DERIVED: 
            case UNION: 
            case ENUMERATION: 
            case BOOLEAN: {
                return String.valueOf(fieldObj).trim();
            }
            case BITS: {
                return YtbUtil.getBitsValue(holder, holderObj, name, fieldObj).trim();
            }
            case BINARY: {
                return Base64.getEncoder().encodeToString((byte[])fieldObj);
            }
            case IDENTITYREF: {
                YangIdentityRef ir = (YangIdentityRef)dataType.getDataTypeExtendedInfo();
                if (ir.isInGrouping()) {
                    return String.valueOf(fieldObj).trim();
                }
                return YtbUtil.getIdentityRefValue(fieldObj, ir, holderObj);
            }
            case LEAFREF: {
                YangLeafRef leafRef = (YangLeafRef)dataType.getDataTypeExtendedInfo();
                return YtbUtil.getStringFromType(holder, holderObj, name, fieldObj, leafRef.getEffectiveDataType());
            }
        }
        throw new YtbException("Unsupported data type. Cannot be processed.");
    }

    private static String getBitsValue(YangSchemaNode holder, Object holderObj, String name, Object fieldObj) {
        Class<?> holderClass = holderObj.getClass();
        String interfaceName = holder.getJavaClassNameOrBuiltInType();
        String className = interfaceName.toLowerCase() + PERIOD + YangIoUtils.getCapitalCase((String)name);
        String pkgName = holder.getJavaPackage() + PERIOD + className;
        ClassLoader classLoader = holderClass.getClassLoader();
        try {
            Class<?> bitClass = classLoader.loadClass(pkgName);
            Method getterMethod = bitClass.getDeclaredMethod(TO_STRING, fieldObj.getClass());
            return String.valueOf(getterMethod.invoke(null, fieldObj));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new YtbException(e);
        }
    }

    private static String getIdentityRefValue(Object fieldObj, YangIdentityRef ir, Object holderObj) {
        YangIdentity id = ir.getReferredIdentity();
        String idName = id.getJavaClassNameOrBuiltInType();
        String idPkg = id.getJavaPackage() + PERIOD + YangIoUtils.getCapitalCase((String)idName);
        String methodName = idName + YangIoUtils.getCapitalCase((String)TO_STRING);
        Class<?> holderClass = holderObj.getClass();
        ClassLoader classLoader = holderClass.getClassLoader();
        try {
            Class<?> idClass = classLoader.loadClass(idPkg);
            Method method = idClass.getDeclaredMethod(methodName, null);
            return String.valueOf(method.invoke(fieldObj, null)).trim();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new YtbException(e);
        }
    }

    private static boolean isPrimitiveDataType(YangDataTypes dataType) {
        return PRIMITIVE_TYPES.contains(dataType);
    }

    public static boolean isNonProcessableNode(YangNode yangNode) {
        return yangNode != null && yangNode instanceof YangNotification || yangNode instanceof YangRpc || yangNode instanceof YangAugment;
    }

    public static boolean isMultiInstanceNode(YangNode yangNode) {
        return yangNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_MULTI_INSTANCE_NODE;
    }

    public static boolean isAugmentNode(YangNode yangNode) {
        return yangNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE;
    }

    public static String emptyObjErrMsg(String objName) {
        return "The " + objName + " given for tree creation cannot be null";
    }

    public static String getJavaName(Object node) {
        return ((JavaLeafInfoContainer)node).getJavaName(null);
    }

    public static boolean nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public static boolean nonEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isNodeProcessCompleted(YangNode curNode, TraversalType curTraversal) {
        return curTraversal == TraversalType.PARENT && curNode instanceof YangNotification || curNode instanceof YangOutput;
    }

    public static String getOpTypeName(YangNode curNode) {
        return YANG + YangIoUtils.getCapitalCase((String)curNode.getJavaClassNameOrBuiltInType()) + OP_TYPE;
    }
}

