/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ysr;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.onosproject.yms.app.ysr.DefaultYangModuleIdentifier;
import org.onosproject.yms.app.ysr.DefaultYangModuleInformation;
import org.onosproject.yms.app.ysr.DefaultYangModuleLibrary;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.ysr.YangModuleIdentifier;
import org.onosproject.yms.ysr.YangModuleLibrary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangSchemaRegistry
implements YangSchemaRegistry {
    private static final String SYSTEM = UtilConstants.SLASH + "system" + UtilConstants.SLASH;
    private static final String MAVEN = "mvn:";
    private static final String JAR = ".jar";
    private static final String USER_DIRECTORY = "user.dir";
    private static final String AT = "@";
    private static final String DATE_FORMAT = "yyyy-mm-dd";
    private static final String ONOS = "org.onosproject";
    private static final Logger log = LoggerFactory.getLogger(DefaultYangSchemaRegistry.class);
    private final ConcurrentMap<String, Object> appObjectStore = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore = new ConcurrentHashMap<String, ConcurrentMap<String, YangSchemaNode>>();
    private final ConcurrentMap<String, YangSchemaNode> interfaceNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
    private final ConcurrentMap<String, YangSchemaNode> opParamNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
    private final ConcurrentMap<String, YangSchemaNode> eventNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
    private final ConcurrentMap<String, YangSchemaNode> appNameKeyStore;
    private final ConcurrentMap<String, Class<?>> registerClassStore = new ConcurrentHashMap();
    private final ConcurrentMap<YangModuleIdentifier, String> yangFileStore = new ConcurrentHashMap<YangModuleIdentifier, String>();
    private final ConcurrentMap<String, YangSchemaNode> nameSpaceSchemaStore;
    private final ConcurrentMap<Object, Boolean> ynhRegistrationStore;
    private final ConcurrentMap<String, String> jarPathStore;

    public DefaultYangSchemaRegistry() {
        this.appNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.ynhRegistrationStore = new ConcurrentHashMap<Object, Boolean>();
        this.jarPathStore = new ConcurrentHashMap<String, String>();
        this.nameSpaceSchemaStore = new ConcurrentHashMap<String, YangSchemaNode>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerApplication(Object appObject, Class<?> serviceClass) {
        Class<DefaultYangSchemaRegistry> clazz = DefaultYangSchemaRegistry.class;
        synchronized (DefaultYangSchemaRegistry.class) {
            BundleContext context;
            this.doPreProcessing(serviceClass, appObject);
            if (!this.verifyIfApplicationAlreadyRegistered(serviceClass) && (context = FrameworkUtil.getBundle(serviceClass).getBundleContext()) != null) {
                Bundle[] bundles = context.getBundles();
                int len = bundles.length;
                for (int i = len - 1; i >= 0; --i) {
                    String jarPath;
                    List<YangNode> curNodes;
                    Bundle bundle = bundles[i];
                    if (!bundle.getSymbolicName().contains(ONOS) || (curNodes = this.processJarParsingOperations(jarPath = this.getJarPathFromBundleLocation(bundle.getLocation(), context.getProperty(USER_DIRECTORY)))) == null || curNodes.isEmpty()) continue;
                    this.jarPathStore.put(serviceClass.getName(), jarPath);
                    this.processRegistration(serviceClass, jarPath, curNodes, appObject, false);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterApplication(Object managerObject, Class<?> serviceClass) {
        Class<DefaultYangSchemaRegistry> clazz = DefaultYangSchemaRegistry.class;
        synchronized (DefaultYangSchemaRegistry.class) {
            String serviceName = serviceClass.getName();
            if (managerObject != null) {
                this.verifyApplicationRegistration(managerObject, serviceClass);
            }
            this.registerClassStore.remove(serviceName);
            YangSchemaNode curNode = (YangSchemaNode)this.appNameKeyStore.get(serviceName);
            if (curNode == null) {
                curNode = (YangSchemaNode)this.interfaceNameKeyStore.get(serviceName);
            }
            if (curNode == null) {
                throw new RuntimeException(serviceClass.getSimpleName() + " service was not registered.");
            }
            this.removeSchemaNode(curNode);
            this.eventNameKeyStore.remove(this.getEventClassName(curNode));
            this.appObjectStore.remove(serviceName);
            this.interfaceNameKeyStore.remove(this.getInterfaceClassName(curNode));
            this.opParamNameKeyStore.remove(this.getOpParamClassName(curNode));
            this.yangFileStore.remove(this.getModuleIdentifier(curNode));
            this.appNameKeyStore.remove(serviceName);
            this.nameSpaceSchemaStore.remove(curNode.getNameSpace().getModuleNamespace());
            this.removeYsrGeneratedTemporaryResources((String)this.jarPathStore.get(serviceName), serviceName);
            log.info(" service {} is unregistered.", (Object)serviceClass.getSimpleName());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Object getRegisteredApplication(YangSchemaNode schemaNode) {
        String name;
        Object obj = null;
        if (schemaNode != null && (obj = this.appObjectStore.get(name = this.getServiceName(schemaNode))) == null) {
            log.error("{} not found.", (Object)name);
        }
        return obj;
    }

    @Override
    public YangSchemaNode getYangSchemaNodeUsingSchemaName(String schemaName) {
        return this.getSchemaNodeUsingSchemaNameWithRev(schemaName);
    }

    @Override
    public YangSchemaNode getYangSchemaNodeUsingAppName(String appName) {
        YangSchemaNode node = (YangSchemaNode)this.appNameKeyStore.get(appName);
        if (node == null) {
            log.error("{} not found.", (Object)appName);
        }
        return node;
    }

    @Override
    public YangSchemaNode getYangSchemaNodeUsingGeneratedRootNodeInterfaceFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.interfaceNameKeyStore.get(name);
        if (node == null) {
            log.error("{} not found.", (Object)name);
        }
        return node;
    }

    @Override
    public YangSchemaNode getYangSchemaNodeUsingGeneratedRootNodeOpPramFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.opParamNameKeyStore.get(name);
        if (node == null) {
            log.error("{} not found.", (Object)name);
        }
        return node;
    }

    @Override
    public YangSchemaNode getRootYangSchemaNodeForNotification(String name) {
        YangSchemaNode node = (YangSchemaNode)this.eventNameKeyStore.get(name);
        if (node == null) {
            log.error("{} not found.", (Object)name);
        }
        return node;
    }

    @Override
    public Class<?> getRegisteredClass(YangSchemaNode schemaNode) {
        String interfaceName = this.getInterfaceClassName(schemaNode);
        String serviceName = this.getServiceName(schemaNode);
        Class regClass = (Class)this.registerClassStore.get(serviceName);
        if (regClass == null) {
            regClass = (Class)this.registerClassStore.get(interfaceName);
        }
        return regClass;
    }

    @Override
    public YangSchemaNode getSchemaWrtNameSpace(String nameSpace) {
        YangSchemaNode node = (YangSchemaNode)this.nameSpaceSchemaStore.get(nameSpace);
        if (node == null) {
            log.error("node with {} namespace not found.", (Object)nameSpace);
        }
        return node;
    }

    @Override
    public String getYangFile(YangModuleIdentifier moduleIdentifier) {
        String file = (String)this.yangFileStore.get(moduleIdentifier);
        if (file == null) {
            log.error("YANG files for corresponding module identifier {} not found", (Object)moduleIdentifier);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyNotificationObject(Object appObj, Class<?> service) {
        Class<DefaultYangSchemaRegistry> clazz = DefaultYangSchemaRegistry.class;
        synchronized (DefaultYangSchemaRegistry.class) {
            YangSchemaNode node = (YangSchemaNode)this.appNameKeyStore.get(service.getName());
            if (node == null) {
                log.error("application is not registered with YMS {}", (Object)service.getName());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            try {
                Boolean ifPresent;
                if (node.isNotificationPresent() && appObj != null && (ifPresent = (Boolean)this.ynhRegistrationStore.get(appObj)) == null) {
                    this.ynhRegistrationStore.put(appObj, true);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
            }
            catch (DataModelException e) {
                log.error("notification registration error: {} {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
            return false;
        }
    }

    @Override
    public void flushYsrData() {
        this.appObjectStore.clear();
        this.yangSchemaStore.clear();
        this.eventNameKeyStore.clear();
        this.opParamNameKeyStore.clear();
        this.interfaceNameKeyStore.clear();
        this.registerClassStore.clear();
        this.yangFileStore.clear();
        this.nameSpaceSchemaStore.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processModuleLibrary(String serviceName, YangModuleLibrary library) {
        Class<DefaultYangSchemaRegistry> clazz = DefaultYangSchemaRegistry.class;
        synchronized (DefaultYangSchemaRegistry.class) {
            YangSchemaNode node = (YangSchemaNode)this.appNameKeyStore.get(serviceName);
            if (node != null) {
                DefaultYangModuleInformation moduleInformation = new DefaultYangModuleInformation(this.getModuleIdentifier(node), node.getNameSpace());
                this.addSubModuleIdentifier(node, moduleInformation);
                ((DefaultYangModuleLibrary)library).addModuleInformation(moduleInformation);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    void doPreProcessing(Class<?> serviceClass, Object appObject) {
        String name;
        if (appObject != null) {
            this.verifyApplicationRegistration(appObject, serviceClass);
        }
        if (!this.registerClassStore.containsKey(name = serviceClass.getName())) {
            this.registerClassStore.put(name, serviceClass);
        }
    }

    void updateServiceClass(Class<?> service) {
        this.registerClassStore.put(service.getName(), service);
    }

    void processRegistration(Class<?> service, String jarPath, List<YangNode> nodes, Object appObj, boolean isFromUt) {
        YangNode schemaNode = this.findNodeWhichShouldBeReg(service.getName(), nodes);
        if (schemaNode != null) {
            if (appObj != null) {
                this.appObjectStore.put(service.getName(), appObj);
            }
            this.processApplicationContext((YangSchemaNode)schemaNode, service.getName(), isFromUt);
            this.updateYangFileStore(schemaNode, jarPath);
        }
    }

    private YangNode findNodeWhichShouldBeReg(String name, List<YangNode> nodes) {
        for (YangNode node : nodes) {
            if (!name.equals(this.getServiceName((YangSchemaNode)node)) && !name.equals(this.getInterfaceClassName((YangSchemaNode)node))) continue;
            return node;
        }
        return null;
    }

    private void verifyApplicationRegistration(Object appObject, Class<?> appClass) {
        Class<?> managerClass = appObject.getClass();
        Class<?>[] services = managerClass.getInterfaces();
        ArrayList classes = new ArrayList();
        Collections.addAll(classes, services);
        if (!classes.contains(appClass)) {
            throw new RuntimeException("service class " + appClass.getName() + "is not being implemented by " + managerClass.getName());
        }
    }

    private boolean verifyIfApplicationAlreadyRegistered(Class<?> appClass) {
        String appName = appClass.getName();
        return this.appObjectStore.containsKey(appName) || this.interfaceNameKeyStore.containsKey(appName);
    }

    private void updateYangFileStore(YangNode node, String jarPath) {
        this.yangFileStore.put(this.getModuleIdentifier((YangSchemaNode)node), this.getYangFilePath(jarPath, node.getFileName()));
    }

    private String getYangFilePath(String jarPath, String metaDataFileName) {
        String[] metaData = metaDataFileName.split(UtilConstants.SLASH);
        return jarPath + UtilConstants.SLASH + metaData[metaData.length - 1];
    }

    private List<YangNode> processJarParsingOperations(String path) {
        String jar = path + JAR;
        try {
            File file = new File(jar);
            if (file.exists()) {
                return DataModelUtils.parseJarFile((String)(path + JAR), (String)path);
            }
        }
        catch (IOException e) {
            log.error(" failed to parse the jar file in path {} : {} ", (Object)path, (Object)e.getMessage());
        }
        return null;
    }

    private void processApplicationContext(YangSchemaNode appNode, String name, boolean isFormUt) {
        this.appNameKeyStore.put(name, appNode);
        this.addToSchemaStore(appNode);
        this.interfaceNameKeyStore.put(this.getInterfaceClassName(appNode), appNode);
        this.opParamNameKeyStore.put(this.getOpParamClassName(appNode), appNode);
        this.nameSpaceSchemaStore.put(appNode.getNameSpace().getModuleNamespace(), appNode);
        String eventSubject = null;
        try {
            if (appNode.isNotificationPresent()) {
                eventSubject = this.getEventClassName(appNode);
            }
        }
        catch (DataModelException e) {
            log.error("failed to search notification from schema map : {}", (Object)e.getLocalizedMessage());
        }
        if (eventSubject != null) {
            this.eventNameKeyStore.put(eventSubject, appNode);
        }
        if (!isFormUt) {
            log.info("successfully registered this application {}", (Object)name);
        }
    }

    private String getJarPathFromBundleLocation(String mvnLocationPath, String currentDirectory) {
        String[] split;
        String[] strArray;
        String path = currentDirectory + SYSTEM;
        if (mvnLocationPath.contains(MAVEN) && (strArray = mvnLocationPath.split(MAVEN))[1].contains(File.separator) && (split = strArray[1].split(File.separator))[0].contains(".")) {
            String[] groupId = split[0].split(Pattern.quote("."));
            return path + groupId[0] + UtilConstants.SLASH + groupId[1] + UtilConstants.SLASH + split[1] + UtilConstants.SLASH + split[2] + UtilConstants.SLASH + split[1] + "-" + split[2];
        }
        return null;
    }

    private YangSchemaNode getSchemaNodeUsingSchemaNameWithRev(String name) {
        ConcurrentMap revMap;
        if (name.contains(AT)) {
            String[] revArray = name.split(AT);
            ConcurrentMap revMap2 = (ConcurrentMap)this.yangSchemaStore.get(revArray[0]);
            YangSchemaNode schemaNode = (YangSchemaNode)revMap2.get(name);
            if (schemaNode == null) {
                log.error("{} not found.", (Object)name);
            }
            return schemaNode;
        }
        if (this.yangSchemaStore.containsKey(name) && (revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty()) {
            YangSchemaNode node = (YangSchemaNode)revMap.get(name);
            if (node != null) {
                return node;
            }
            String revName = this.getLatestVersion(revMap);
            return (YangSchemaNode)revMap.get(revName);
        }
        log.error("{} not found.", (Object)name);
        return null;
    }

    private String getLatestVersion(ConcurrentMap<String, YangSchemaNode> revMap) {
        ArrayList keys = new ArrayList();
        for (Map.Entry entry : revMap.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys);
        return (String)keys.get(keys.size() - 1);
    }

    private void addToSchemaStore(YangSchemaNode schemaNode) {
        String name;
        String date = this.getDateInStringFormat(schemaNode);
        String revName = name = schemaNode.getName();
        if (date != null) {
            revName = name + AT + date;
        }
        if (!this.yangSchemaStore.containsKey(name)) {
            ConcurrentHashMap<String, YangSchemaNode> revStore = new ConcurrentHashMap<String, YangSchemaNode>();
            revStore.put(revName, schemaNode);
            this.yangSchemaStore.put(name, revStore);
        } else {
            ((ConcurrentMap)this.yangSchemaStore.get(name)).put(revName, schemaNode);
        }
    }

    String getDateInStringFormat(YangSchemaNode schemaNode) {
        if (schemaNode != null && ((YangNode)schemaNode).getRevision() != null) {
            return new SimpleDateFormat(DATE_FORMAT).format(((YangNode)schemaNode).getRevision().getRevDate());
        }
        return null;
    }

    private void removeSchemaNode(YangSchemaNode removableNode) {
        ConcurrentMap revMap;
        String name;
        String revName = name = removableNode.getName();
        String date = this.getDateInStringFormat(removableNode);
        if (date != null) {
            revName = name + AT + date;
        }
        if ((revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty() && revMap.size() != 1) {
            revMap.remove(revName);
        } else {
            this.yangSchemaStore.remove(removableNode.getName());
        }
    }

    private void addSubModuleIdentifier(YangSchemaNode node, DefaultYangModuleInformation information) {
        List includeList = new ArrayList();
        if (node instanceof YangModule) {
            includeList = ((YangModule)node).getIncludeList();
        } else if (node instanceof YangSubModule) {
            includeList = ((YangSubModule)node).getIncludeList();
        }
        for (YangInclude include : includeList) {
            information.addSubModuleIdentifiers(this.getModuleIdentifier((YangSchemaNode)include.getIncludedNode()));
        }
    }

    private YangModuleIdentifier getModuleIdentifier(YangSchemaNode schemaNode) {
        return new DefaultYangModuleIdentifier(schemaNode.getName(), this.getDateInStringFormat(schemaNode));
    }

    String getInterfaceClassName(YangSchemaNode schemaNode) {
        return schemaNode.getJavaPackage() + "." + YangIoUtils.getCapitalCase((String)schemaNode.getJavaClassNameOrBuiltInType());
    }

    private String getOpParamClassName(YangSchemaNode schemaNode) {
        return this.getInterfaceClassName(schemaNode) + "OpParam";
    }

    private String getEventClassName(YangSchemaNode schemaNode) {
        return this.getInterfaceClassName(schemaNode).toLowerCase() + "." + YangIoUtils.getCapitalCase((String)schemaNode.getJavaClassNameOrBuiltInType()) + "Event";
    }

    String getServiceName(YangSchemaNode schemaNode) {
        return this.getInterfaceClassName(schemaNode) + "Service";
    }

    private void removeYsrGeneratedTemporaryResources(String rscPath, String appName) {
        File jarPath;
        if (rscPath != null && (jarPath = new File(rscPath)).exists()) {
            try {
                FileUtils.deleteDirectory((File)jarPath);
            }
            catch (IOException e) {
                log.error("failed to delete ysr resources for {} : {}", (Object)appName, (Object)e.getLocalizedMessage());
            }
        }
    }
}

