/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.yob;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yms.app.ydt.AppType;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.yob.YobBuilderOrBuiltObject;
import org.onosproject.yms.app.yob.YobUtils;
import org.onosproject.yms.app.yob.exception.YobException;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YdtType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class YobWorkBench {
    private static final Logger log = LoggerFactory.getLogger(YobWorkBench.class);
    private ClassLoader classLoader;
    private Map<YangSchemaNodeIdentifier, YobWorkBench> attributeMap = new HashMap<YangSchemaNodeIdentifier, YobWorkBench>();
    private YangSchemaNode yangSchemaNode;
    private YobBuilderOrBuiltObject builderOrBuiltObject;
    private String setterInParent;

    YobWorkBench(YangSchemaNode yangSchemaNode, ClassLoader classLoader, String qualifiedClassName, String setterInParent) {
        this.yangSchemaNode = yangSchemaNode;
        this.classLoader = classLoader;
        this.setterInParent = setterInParent;
        this.builderOrBuiltObject = new YobBuilderOrBuiltObject(qualifiedClassName, classLoader);
    }

    private static void setObjectInBuilder(Object builder, String setter, YdtType nodeType, Object attribute) {
        Class<?> builderClass = builder.getClass();
        String builderClassName = builderClass.getName();
        try {
            Method method;
            Class type = null;
            Field fieldName = builderClass.getDeclaredField(setter);
            if (fieldName != null) {
                type = fieldName.getType();
            }
            if (nodeType == YdtType.MULTI_INSTANCE_NODE) {
                if (fieldName != null) {
                    ParameterizedType genericTypes = (ParameterizedType)fieldName.getGenericType();
                    type = (Class)genericTypes.getActualTypeArguments()[0];
                }
                method = builderClass.getDeclaredMethod("addTo" + YobUtils.getCapitalCase(setter), type);
            } else {
                method = builderClass.getDeclaredMethod(setter, type);
            }
            method.invoke(builder, attribute);
        }
        catch (NoSuchFieldException e) {
            log.error("Failed to get field for class: {}", (Object)builderClassName);
            throw new YobException("Failed to get field for class: " + builderClassName);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)builderClassName);
            throw new YobException("Failed to get method for class: " + builderClassName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)builderClassName);
            throw new YobException("Failed to invoke method for class: " + builderClassName);
        }
    }

    private static void addInAugmentation(Object builder, String className, Object instance) {
        int i;
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        if (interfaces == null) {
            throw new YobException("Failed to load class for class: " + className);
        }
        for (i = 0; i < interfaces.length && !interfaces[i].getName().equals(className); ++i) {
        }
        if (i == interfaces.length) {
            throw new YobException("Failed to load class for class: " + className);
        }
        Class<?> builderClass = builder.getClass();
        String builderClassName = builderClass.getName();
        try {
            Method method = builderClass.getDeclaredMethod("addYangAugmentedInfo", Object.class, Class.class);
            method.invoke(builder, instance, interfaces[i]);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)builderClassName);
            throw new YobException("Failed to get method for class: " + builderClassName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)builderClassName);
            throw new YobException("Failed to invoke method for class: " + builderClassName);
        }
    }

    private static YobWorkBench getNewChildWorkBench(YangSchemaNodeContextInfo childContext, YangSchemaNodeIdentifier targetNode, YobWorkBench curWorkBench, YangSchemaRegistry registry) {
        String name;
        YangSchemaNode ctxSwitchedNode = childContext.getContextSwitchedNode();
        String setterInParent = ctxSwitchedNode.getJavaAttributeName();
        if (ctxSwitchedNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_CHOICE_NODE) {
            try {
                childContext = ctxSwitchedNode.getChildSchema(targetNode);
                ctxSwitchedNode = childContext.getContextSwitchedNode();
                name = YobUtils.getQualifiedDefaultClass(childContext.getContextSwitchedNode());
            }
            catch (DataModelException e) {
                throw new YobException(ctxSwitchedNode.getName() + " does not have child " + targetNode.getName());
            }
        } else if (ctxSwitchedNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
            name = YobUtils.getQualifiedDefaultClass(ctxSwitchedNode);
            setterInParent = YobUtils.getQualifiedinterface(ctxSwitchedNode);
        } else {
            name = YobUtils.getQualifiedDefaultClass(childContext.getSchemaNode());
        }
        ClassLoader newClassesLoader = YobUtils.getTargetClassLoader(curWorkBench.classLoader, childContext, registry);
        return new YobWorkBench(ctxSwitchedNode, newClassesLoader, name, setterInParent);
    }

    YobBuilderOrBuiltObject getBuilderOrBuiltObject() {
        return this.builderOrBuiltObject;
    }

    Object getParentBuilder(YdtExtendedContext node, YangSchemaRegistry registry) {
        YangSchemaNode nonSchemaHolder;
        YangSchemaNodeIdentifier targetNode = node.getYangSchemaNode().getYangSchemaNodeIdentifier();
        YobWorkBench curWorkBench = this;
        do {
            YangSchemaNodeContextInfo schemaContext;
            try {
                schemaContext = curWorkBench.yangSchemaNode.getChildSchema(targetNode);
            }
            catch (DataModelException e) {
                throw new YobException(this.yangSchemaNode.getName() + " does not have child " + targetNode.getName());
            }
            nonSchemaHolder = schemaContext.getContextSwitchedNode();
            if (nonSchemaHolder == null) continue;
            YangSchemaNodeIdentifier nonSchemaIdentifier = nonSchemaHolder.getYangSchemaNodeIdentifier();
            YobWorkBench childWorkBench = curWorkBench.attributeMap.get(nonSchemaIdentifier);
            if (childWorkBench == null) {
                YobWorkBench newWorkBench = YobWorkBench.getNewChildWorkBench(schemaContext, targetNode, curWorkBench, registry);
                curWorkBench.attributeMap.put(nonSchemaIdentifier, newWorkBench);
                curWorkBench = newWorkBench;
                continue;
            }
            curWorkBench = childWorkBench;
        } while (nonSchemaHolder != null);
        return curWorkBench.builderOrBuiltObject.getBuilderObject();
    }

    void buildObject(YdtContextOperationType operationType, YangSchemaRegistry schemaRegistry) {
        this.buildNonSchemaAttributes(operationType, schemaRegistry);
        Object builderObject = this.builderOrBuiltObject.getBuilderObject();
        Class<?> defaultBuilderClass = this.builderOrBuiltObject.yangBuilderClass;
        this.setOperationType(operationType, schemaRegistry);
        try {
            Method method = defaultBuilderClass.getDeclaredMethod("build", new Class[0]);
            if (method == null) {
                log.error("Failed to get method for class: {}", (Object)defaultBuilderClass.getName());
                throw new YobException("Failed to get method for class: " + defaultBuilderClass.getName());
            }
            Object builtObject = method.invoke(builderObject, new Object[0]);
            this.builderOrBuiltObject.setBuiltObject(builtObject);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to build the object: {}", (Object)defaultBuilderClass.getName());
            throw new YobException("Failed to build the object: " + defaultBuilderClass.getName());
        }
    }

    private void setOperationType(YdtContextOperationType ydtoperation, YangSchemaRegistry schemaRegistry) {
        if (ydtoperation == null) {
            return;
        }
        Object builderObject = this.builderOrBuiltObject.getBuilderObject();
        Class<?> defaultBuilderClass = this.builderOrBuiltObject.yangBuilderClass;
        Class<?>[] intfClass = this.builderOrBuiltObject.yangDefaultClass.getInterfaces();
        String setterName = "yang" + intfClass[0].getSimpleName() + "OpType";
        try {
            Class<?>[] innerClasses;
            Class<?> interfaceClass = YobUtils.getModuleInterface(this.yangSchemaNode, schemaRegistry);
            for (Class<?> innerEnumClass : innerClasses = interfaceClass.getClasses()) {
                if (!innerEnumClass.getSimpleName().equals("OnosYangOpType")) continue;
                Method valueOfMethod = innerEnumClass.getDeclaredMethod("valueOf", String.class);
                Object operationType = valueOfMethod.invoke(null, ydtoperation.toString());
                Field operationTypeField = defaultBuilderClass.getDeclaredField(setterName);
                operationTypeField.setAccessible(true);
                operationTypeField.set(builderObject, operationType);
                break;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to set Operation Type");
            throw new YobException("Failed to set Operation Type");
        }
        catch (NoSuchFieldException e) {
            log.error("Failed to set Operation Type");
        }
    }

    private void buildNonSchemaAttributes(YdtContextOperationType operationType, YangSchemaRegistry schemaRegistry) {
        for (Map.Entry<YangSchemaNodeIdentifier, YobWorkBench> entry : this.attributeMap.entrySet()) {
            YobWorkBench childWorkBench = entry.getValue();
            childWorkBench.buildObject(operationType, schemaRegistry);
            if (childWorkBench.yangSchemaNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
                YobWorkBench.addInAugmentation(this.builderOrBuiltObject.getBuilderObject(), childWorkBench.setterInParent, childWorkBench.getBuilderOrBuiltObject().getBuiltObject());
                continue;
            }
            YobWorkBench.setObjectInBuilder(this.builderOrBuiltObject.getBuilderObject(), childWorkBench.setterInParent, YdtType.SINGLE_INSTANCE_NODE, childWorkBench.getBuilderOrBuiltObject().getBuiltObject());
        }
    }

    public void setObject(YdtExtendedContext childnode, YangSchemaRegistry schemaRegistry) {
        Object builder = this.getParentBuilder(childnode, schemaRegistry);
        YobWorkBench childWorkBench = (YobWorkBench)childnode.getAppInfo(AppType.YOB);
        YobWorkBench.setObjectInBuilder(builder, childWorkBench.setterInParent, childnode.getYdtType(), childWorkBench.builderOrBuiltObject.getBuiltObject());
    }
}

