/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yms.app.ydt.AppNodeFactory;
import org.onosproject.yms.app.ydt.DefaultYdtAppContext;
import org.onosproject.yms.app.ydt.RequestedCallType;
import org.onosproject.yms.app.ydt.RequestedCardinality;
import org.onosproject.yms.app.ydt.YdtAppContext;
import org.onosproject.yms.app.ydt.YdtAppNodeOperationType;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtExtendedBuilder;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ydt.YdtLogicalNode;
import org.onosproject.yms.app.ydt.YdtMultiInstanceNode;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.ydt.YdtNodeFactory;
import org.onosproject.yms.app.ydt.YdtSingleInstanceNode;
import org.onosproject.yms.app.ydt.YdtUtils;
import org.onosproject.yms.app.ydt.exceptions.YdtException;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YdtType;
import org.onosproject.yms.ydt.YmsOperationType;

public class YangRequestWorkBench
implements YdtExtendedBuilder {
    private static final String FMT_NOT_EXIST = "Application with name \"%s\" doesn't exist.";
    private static final String E_USE_ADD_LEAF = "Requested Node should be created using addLeaf interface.";
    private static final String E_INVOKE_PARENT = "Can't invoke get parent at logical root node.";
    private YdtNode curNode;
    private YdtNode rootNode;
    private YdtAppContext appCurNode;
    private YdtAppContext appRootNode;
    private Map<String, String> rootTagAttributeMap;
    private YangSchemaRegistry registry = null;
    private final YmsOperationType ymsOperationType;
    private YdtContextOperationType ydtDefaultOpType;
    private boolean validate = false;
    private Set<String> augGenMethodSet;

    public YangRequestWorkBench(String name, String namespace, YmsOperationType opType, YangSchemaRegistry reg, boolean isValidate) {
        this.setRootNode(new YdtLogicalNode(name, namespace));
        this.registry = reg;
        this.ymsOperationType = opType;
        this.validate = isValidate;
        this.setAppRootNode(AppNodeFactory.getAppContext(true));
    }

    private void setRootNode(YdtNode node) {
        this.rootNode = node;
        this.curNode = node;
    }

    private void setAppRootNode(YdtAppContext node) {
        this.appRootNode = node;
        this.appCurNode = node;
    }

    public YangSchemaRegistry getYangSchemaRegistry() {
        return this.registry;
    }

    public YdtAppContext getAppRootNode() {
        return this.appRootNode;
    }

    private YdtNode moduleHandler(YangSchemaNodeIdentifier id) throws YdtException {
        YangSchemaNode node = this.registry.getYangSchemaNodeUsingSchemaName(id.getName());
        String namespace = id.getNameSpace().getModuleNamespace();
        if (node == null || namespace != null && !namespace.equals(node.getYangSchemaNodeIdentifier().getNameSpace().getModuleNamespace())) {
            throw new YdtException(YdtConstants.errorMsg(FMT_NOT_EXIST, id.getName()));
        }
        if (this.ymsOperationType != YmsOperationType.QUERY_REQUEST) {
            try {
                this.curNode.getCollidingChild(id);
            }
            catch (YdtException e) {
                throw new YdtException(e.getLocalizedMessage());
            }
        }
        YdtSingleInstanceNode newNode = new YdtSingleInstanceNode(node);
        newNode.setYangSchemaNode(node);
        return newNode;
    }

    public void setRootTagAttributeMap(Map<String, String> attributeTag) {
        this.rootTagAttributeMap = attributeTag;
    }

    public Map<String, String> getRootTagAttributeMap() {
        if (this.rootTagAttributeMap != null) {
            return ImmutableMap.copyOf(this.rootTagAttributeMap);
        }
        return null;
    }

    public void addChild(String name, String namespace) throws IllegalArgumentException {
        this.addChild(name, namespace, RequestedCardinality.UNKNOWN, null, RequestedCallType.NON_LEAF);
    }

    public void addChild(String name, String namespace, YdtType ydtType) throws IllegalArgumentException {
        this.addChild(name, namespace, ydtType, null);
    }

    public void addChild(String name, String namespace, YdtContextOperationType opType) throws IllegalArgumentException {
        this.addChild(name, namespace, RequestedCardinality.UNKNOWN, opType, RequestedCallType.NON_LEAF);
    }

    public void addChild(String name, String namespace, YdtType ydtType, YdtContextOperationType opType) throws IllegalArgumentException {
        RequestedCardinality cardinality;
        switch (ydtType) {
            case MULTI_INSTANCE_NODE: {
                cardinality = RequestedCardinality.MULTI_INSTANCE;
                break;
            }
            case SINGLE_INSTANCE_NODE: {
                cardinality = RequestedCardinality.SINGLE_INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException(E_USE_ADD_LEAF);
            }
        }
        this.addChild(name, namespace, cardinality, opType, RequestedCallType.NON_LEAF);
    }

    private void addChild(String name, String namespace, RequestedCardinality cardinality, YdtContextOperationType opType, RequestedCallType callType) throws IllegalArgumentException {
        YdtNode newNode;
        boolean contextSwitch = false;
        YangSchemaNode augmentingSchema = null;
        YangSchemaNodeIdentifier id = YdtUtils.getNodeIdentifier(name, namespace);
        if (name == null) {
            if (!this.curNode.equals(this.rootNode)) {
                throw new YdtException("Name is null for node other than module");
            }
            YangSchemaNode node = this.registry.getSchemaWrtNameSpace(id.getNameSpace().getModuleNamespace());
            id.setName(node.getName());
        }
        try {
            if (this.curNode.equals(this.rootNode)) {
                newNode = this.moduleHandler(id);
            } else {
                YangSchemaNode schemaNode;
                if (namespace == null) {
                    id.setNameSpace(this.curNode.getYangSchemaNode().getNameSpace());
                }
                if ((newNode = this.curNode.getCollidingChild(id)) == null) {
                    YangSchemaNodeContextInfo contextInfo = this.curNode.getSchemaNodeContextInfo(id);
                    if (contextInfo.getContextSwitchedNode() != null && (augmentingSchema = YdtUtils.getAugmentingSchemaNode(id, contextInfo)) != null) {
                        contextSwitch = true;
                    }
                    schemaNode = contextInfo.getSchemaNode();
                } else {
                    if (newNode.getYdtType() == YdtType.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                        this.curNode = newNode;
                        return;
                    }
                    schemaNode = newNode.getYangSchemaNode();
                }
                newNode = this.ymsOperationType == YmsOperationType.QUERY_REQUEST ? YdtNodeFactory.getYangSchemaNodeTypeSpecificContext(schemaNode) : YdtNodeFactory.getNode(schemaNode, cardinality, callType);
            }
            opType = YdtUtils.getValidOpType(opType, this.ydtDefaultOpType, newNode, this.curNode);
            newNode.setYdtContextOperationType(opType);
            this.curNode.addChild(newNode, true);
        }
        catch (YdtException e) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        this.curNode.updateYdtMap(newNode);
        this.processAppTree(opType, newNode, augmentingSchema, contextSwitch);
        this.curNode = newNode;
    }

    private void processAppTree(YdtContextOperationType opType, YdtNode childNode, YangSchemaNode augmentingSchema, boolean contextSwitch) {
        if (this.curNode == this.rootNode) {
            this.augGenMethodSet = new HashSet<String>();
        }
        if (opType == null) {
            opType = this.curNode.getYdtContextOperationType();
        } else {
            this.appCurNode.updateAppOperationType(opType);
        }
        if (augmentingSchema != null && !this.augGenMethodSet.add(((YangAugment)augmentingSchema).getSetterMethodName())) {
            return;
        }
        if (this.curNode.equals(this.rootNode) || contextSwitch) {
            this.addChildInAppTree(childNode, augmentingSchema, opType, contextSwitch);
            this.appCurNode.setOperationType(YdtUtils.getAppOpTypeFromYdtOpType(opType));
        }
        if (opType == YdtContextOperationType.DELETE || opType == YdtContextOperationType.REMOVE) {
            this.appCurNode.addDeleteNode(childNode);
        }
    }

    private void addChildInAppTree(YdtNode childNode, YangSchemaNode schemaNode, YdtContextOperationType childOpType, boolean isContextSwitch) {
        DefaultYdtAppContext appContext = AppNodeFactory.getAppContext(isContextSwitch);
        this.appCurNode.addChild(appContext);
        this.appCurNode = appContext;
        YdtAppNodeOperationType opType = YdtUtils.getAppOpTypeFromYdtOpType(childOpType);
        this.appCurNode.setAppData(childNode, schemaNode);
        this.appCurNode.setOperationType(opType);
        childNode.setAppContextSwitch();
    }

    public void addLeaf(String name, String namespace, String value) throws IllegalArgumentException {
        this.addLeaf(name, namespace, value, null, RequestedCardinality.UNKNOWN);
    }

    public void addLeaf(String name, String namespace, Set<String> valueSet) throws IllegalArgumentException {
        this.addLeaf(name, namespace, null, valueSet, RequestedCardinality.MULTI_INSTANCE_LEAF);
    }

    public void addNode(String name, String namespace) throws IllegalArgumentException {
        this.addChild(name, namespace, RequestedCardinality.UNKNOWN, null, RequestedCallType.EMPTY_CONTAINER);
    }

    private void addLeaf(String name, String namespace, String value, Set<String> valueSet, RequestedCardinality cardinality) throws IllegalArgumentException {
        try {
            this.addChild(name, namespace, cardinality, null, RequestedCallType.LEAF);
            if (value != null) {
                this.curNode.addValue(value);
            } else if (valueSet != null) {
                this.curNode.addValueSet(valueSet);
            }
        }
        catch (YdtException e) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    public void traverseToParent() throws IllegalStateException {
        if (this.curNode.equals(this.rootNode)) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalStateException(E_INVOKE_PARENT);
        }
        try {
            List<YdtContext> keyList;
            if (this.curNode.getYdtType() == YdtType.MULTI_INSTANCE_NODE && ((keyList = ((YdtMultiInstanceNode)this.curNode).getKeyNodeList()) == null || keyList.isEmpty())) {
                this.curNode.createKeyNodeList();
            }
            if (this.curNode.getParent().equals(this.rootNode) || this.curNode.getAppContextSwitch()) {
                this.traverseToAppTreeParent();
            }
            if (this.curNode instanceof YdtMultiInstanceNode || this.curNode instanceof YdtSingleInstanceNode) {
                this.curNode.validateMultiInstanceNode();
            }
            this.curNode = this.curNode.getParent();
        }
        catch (YdtException e) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalStateException(e.getLocalizedMessage());
        }
    }

    private void traverseToAppTreeParent() {
        this.appCurNode = this.appCurNode.getParent();
    }

    @Override
    public YdtExtendedContext getCurNode() {
        return this.curNode;
    }

    public void setDefaultEditOperationType(YdtContextOperationType opType) {
        this.ydtDefaultOpType = opType;
    }

    @Override
    public YdtExtendedContext getRootNode() {
        return this.rootNode;
    }

    public YmsOperationType getYmsOperationType() {
        return this.ymsOperationType;
    }

    public void addMultiInstanceChild(String name, String namespace, List<String> keysValueList, YdtContextOperationType opType) throws IllegalArgumentException {
        this.addChild(name, namespace, RequestedCardinality.UNKNOWN, opType, RequestedCallType.MULTI_INSTANCE);
        int inputCount = keysValueList.size();
        try {
            if (this.curNode.getYdtType() == YdtType.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                for (String value : keysValueList) {
                    this.curNode.addValue(value);
                }
            } else if (this.curNode.getYdtType() == YdtType.MULTI_INSTANCE_NODE) {
                YangList yangListHolder = (YangList)this.curNode.getYangSchemaNode();
                List schemaKeyList = yangListHolder.getKeyList();
                int expectedCount = schemaKeyList.size();
                YdtUtils.checkElementCount(name, expectedCount, inputCount);
                Iterator sklIter = schemaKeyList.iterator();
                Iterator<String> kvlIter = keysValueList.iterator();
                while (kvlIter.hasNext()) {
                    String value = kvlIter.next();
                    String keyEleName = (String)sklIter.next();
                    this.addLeaf(keyEleName, namespace, value);
                    if (!kvlIter.hasNext()) continue;
                    this.traverseToParentWithoutValidation();
                }
                this.curNode = this.curNode.getParent();
                this.curNode.createKeyNodeList();
            }
        }
        catch (YdtException e) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    private YdtNode addExtendedChildNode(YdtContextOperationType opType, YangSchemaNode schemaNode) {
        YdtNode childNode = YdtNodeFactory.getYangSchemaNodeTypeSpecificContext(schemaNode);
        childNode.setYangSchemaNode(schemaNode);
        childNode.setYdtContextOperationType(opType);
        this.curNode.addChild(childNode, true);
        this.curNode = childNode;
        return childNode;
    }

    @Override
    public YdtExtendedContext addChild(YdtContextOperationType opType, YangSchemaNode schemaNode) {
        return this.addExtendedChildNode(opType, schemaNode);
    }

    @Override
    public YdtExtendedContext addLeafList(Set<String> valueSet, YangSchemaNode schemaNode) {
        YdtNode childNode = this.addExtendedChildNode(null, schemaNode);
        childNode.addValueSetWithoutValidation(valueSet);
        return childNode;
    }

    @Override
    public YdtExtendedContext addLeaf(String value, YangSchemaNode schemaNode) {
        YdtNode childNode = this.addExtendedChildNode(null, schemaNode);
        childNode.addValueWithoutValidation(value, ((YangLeaf)schemaNode).isKeyLeaf());
        return childNode;
    }

    @Override
    public void traverseToParentWithoutValidation() throws IllegalStateException {
        if (this.curNode.equals(this.rootNode)) {
            YdtUtils.freeRestResources(this.rootNode);
            throw new IllegalStateException(E_INVOKE_PARENT);
        }
        this.curNode = this.curNode.getParent();
    }

    public Set<String> getAugGenMethodSet() {
        return this.augGenMethodSet;
    }

    public void setAugGenMethodSet(Set<String> augGenMethodSet) {
        this.augGenMethodSet = augGenMethodSet;
    }
}

