/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import org.onosproject.yms.app.utils.TraversalType;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ydt.YdtExtendedListener;
import org.onosproject.yms.app.ydt.YdtExtendedWalker;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtListener;

public class DefaultYdtWalker
implements YdtExtendedWalker {
    public void walk(YdtListener ydtListener, YdtContext rootNode) {
        this.walkTree(ydtListener, rootNode, false);
    }

    private void walkTree(YdtListener ydtListener, YdtContext rootNode, boolean isExtended) {
        YdtContext curNode = rootNode;
        TraversalType curTraversal = TraversalType.ROOT;
        while (curNode != null) {
            if (curTraversal != TraversalType.PARENT) {
                if (isExtended) {
                    ((YdtExtendedListener)ydtListener).enterYdtNode((YdtExtendedContext)curNode);
                } else {
                    ydtListener.enterYdtNode(curNode);
                }
            }
            if (curTraversal != TraversalType.PARENT && curNode.getFirstChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getFirstChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                this.exitCallBack(ydtListener, curNode, isExtended);
                if (curNode.equals(rootNode)) {
                    return;
                }
                curTraversal = TraversalType.SIBLING;
                curNode = curNode.getNextSibling();
                continue;
            }
            this.exitCallBack(ydtListener, curNode, isExtended);
            if (curNode.equals(rootNode)) {
                return;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
    }

    private void exitCallBack(YdtListener ydtListener, YdtContext curNode, boolean isExtended) {
        if (isExtended) {
            ((YdtExtendedListener)ydtListener).exitYdtNode((YdtExtendedContext)curNode);
        } else {
            ydtListener.exitYdtNode(curNode);
        }
    }

    @Override
    public void walk(YdtExtendedListener ydtExtendedListener, YdtExtendedContext rootNode) {
        this.walkTree(ydtExtendedListener, rootNode, true);
    }
}

