/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs.xml;

import java.util.Objects;
import java.util.Stack;
import org.dom4j.Element;
import org.onosproject.yms.app.ych.defaultcodecs.CodecHandlerFactory;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecHandler;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ydt.YdtExtendedListener;
import org.onosproject.yms.ych.YangProtocolEncodingFormat;
import org.onosproject.yms.ydt.YdtContext;

class XmlCodecYdtListener
implements YdtExtendedListener {
    private YangProtocolEncodingFormat dataFormat;
    private final Stack<Element> elementStack = new Stack();
    private YdtExtendedContext rootYdtNode;
    private YdtExtendedContext currentModule;

    XmlCodecYdtListener(YangProtocolEncodingFormat format, YdtExtendedContext rootNode) {
        this.dataFormat = format;
        this.rootYdtNode = rootNode;
        this.currentModule = (YdtExtendedContext)rootNode.getFirstChild();
    }

    Stack<Element> getElementStack() {
        return this.elementStack;
    }

    private boolean isModuleNode(YdtExtendedContext ydtContext, boolean isExit) {
        if (Objects.equals(this.currentModule, ydtContext)) {
            if (isExit) {
                this.currentModule = (YdtExtendedContext)this.currentModule.getNextSibling();
            }
            return true;
        }
        return false;
    }

    @Override
    public void enterYdtNode(YdtExtendedContext ydtContext) {
        if (!Objects.equals(this.rootYdtNode, ydtContext) && !this.isModuleNode(ydtContext, false)) {
            CodecHandlerFactory factory = CodecHandlerFactory.instance();
            XmlCodecHandler handler = factory.getCodecHandlerForContext(ydtContext, this.dataFormat);
            try {
                if (this.dataFormat == YangProtocolEncodingFormat.XML && handler != null) {
                    handler.processXmlContext(ydtContext, this.elementStack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.dataFormat == YangProtocolEncodingFormat.XML && handler != null) {
                handler.setXmlValue(ydtContext, this.elementStack);
            }
        }
    }

    @Override
    public void exitYdtNode(YdtExtendedContext ydtExtendedContext) {
        if (!Objects.equals(this.rootYdtNode, ydtExtendedContext) && !this.isModuleNode(ydtExtendedContext, true)) {
            this.elementStack.pop();
        }
    }

    public void enterYdtNode(YdtContext ydtContext) {
    }

    public void exitYdtNode(YdtContext ydtContext) {
    }
}

