/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs.xml;

import java.util.Iterator;
import org.dom4j.Element;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlListener;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlNodeType;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultXmlCodecWalker
implements XmlWalker {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    DefaultXmlCodecWalker() {
    }

    @Override
    public void walk(XmlListener listener, Element element, Element rootElement) {
        try {
            Element newElement = element.createCopy();
            newElement.remove(element.getNamespace());
            listener.enterXmlElement(element, this.getElementType(newElement), rootElement);
            if (element.hasContent() && !element.isTextOnly()) {
                Iterator i = element.elementIterator();
                while (i.hasNext()) {
                    Element childElement = (Element)i.next();
                    this.walk(listener, childElement, rootElement);
                }
            }
            listener.exitXmlElement(element, this.getElementType(element), rootElement);
        }
        catch (Exception e) {
            this.log.error("Exception occurred when walk xml element: {}", (Object)element);
        }
    }

    private XmlNodeType getElementType(Element element) {
        return element.hasContent() && element.isTextOnly() ? XmlNodeType.TEXT_NODE : XmlNodeType.OBJECT_NODE;
    }
}

