/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs.xml;

import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.onosproject.yms.app.ych.YchException;
import org.onosproject.yms.app.ych.defaultcodecs.netconf.NetconfCodec;
import org.onosproject.yms.app.ych.defaultcodecs.utils.DefaultCodecUtils;
import org.onosproject.yms.app.ych.defaultcodecs.xml.DefaultXmlCodecWalker;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecListener;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecYdtListener;
import org.onosproject.yms.app.ych.defaultcodecs.xml.YangCompositeEncodingImpl;
import org.onosproject.yms.app.ydt.DefaultYdtWalker;
import org.onosproject.yms.app.ydt.YangRequestWorkBench;
import org.onosproject.yms.app.ydt.YdtExtendedBuilder;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.ych.YangCompositeEncoding;
import org.onosproject.yms.ych.YangDataTreeCodec;
import org.onosproject.yms.ych.YangProtocolEncodingFormat;
import org.onosproject.yms.ydt.YdtBuilder;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YmsOperationType;

public class DefaultXmlCodec
implements YangDataTreeCodec {
    private static final String E_RESTCONF_ROOT = "/onos/restconf";
    private static final String E_YDT_ROOT_NODE = "YDT extended root node is null.";
    private static final String E_ROOT_ELEMENT = "Root element in XML input string is not well-formed.";
    private static final String E_ROOT_KEY_ELEMENT = "Root element (filter, config, data) in XML input string is not found.";

    private String buildXmlForYdt(YdtBuilder ydtBuilder) {
        Map tagAttrMap;
        YdtExtendedBuilder extBuilder = (YdtExtendedBuilder)ydtBuilder;
        YdtExtendedContext rootNode = extBuilder.getRootNode();
        if (rootNode == null) {
            throw new YchException(E_YDT_ROOT_NODE);
        }
        Element rootElement = DocumentHelper.createDocument().addElement(rootNode.getName());
        if (rootNode.getNamespace() != null) {
            rootElement.add(Namespace.get((String)rootNode.getNamespace()));
        }
        if ("config".equals(rootElement.getName())) {
            rootElement.add(new Namespace("nc", "urn:ietf:params:xml:ns:netconf:base:1.0"));
        }
        if ((tagAttrMap = extBuilder.getRootTagAttributeMap()) != null && !tagAttrMap.isEmpty()) {
            for (Map.Entry attr : tagAttrMap.entrySet()) {
                rootElement.addAttribute((String)attr.getKey(), (String)attr.getValue());
            }
        }
        XmlCodecYdtListener listener = new XmlCodecYdtListener(YangProtocolEncodingFormat.XML, rootNode);
        listener.getElementStack().push(rootElement);
        DefaultYdtWalker extWalker = new DefaultYdtWalker();
        extWalker.walk(listener, rootNode);
        return rootElement.asXML();
    }

    public String encodeYdtToProtocolFormat(YdtBuilder ydtBuilder) {
        return this.buildXmlForYdt(ydtBuilder);
    }

    public YangCompositeEncoding encodeYdtToCompositeProtocolFormat(YdtBuilder ydtBuilder) {
        YangCompositeEncodingImpl encoding = new YangCompositeEncodingImpl();
        encoding.setResourceIdentifier(null);
        encoding.setResourceInformation(this.buildXmlForYdt(ydtBuilder));
        return encoding;
    }

    public YdtBuilder decodeCompositeProtocolDataToYdt(YangCompositeEncoding protoData, Object schemaReg, YmsOperationType opType) {
        Document document;
        YangRequestWorkBench extBuilder = new YangRequestWorkBench(E_RESTCONF_ROOT, null, opType, (YangSchemaRegistry)schemaReg, false);
        DefaultCodecUtils.convertUriToYdt(protoData.getResourceIdentifier(), extBuilder, YdtContextOperationType.CREATE);
        try {
            document = DocumentHelper.parseText((String)protoData.getResourceInformation());
        }
        catch (DocumentException e) {
            throw new YchException(E_ROOT_ELEMENT);
        }
        XmlCodecListener listener = new XmlCodecListener();
        listener.setYdtExtBuilder(extBuilder);
        DefaultXmlCodecWalker walker = new DefaultXmlCodecWalker();
        walker.walk(listener, document.getRootElement(), document.getRootElement());
        return extBuilder;
    }

    public YdtBuilder decodeProtocolDataToYdt(String protoData, Object schemaReg, YmsOperationType opType) {
        Document document;
        try {
            document = DocumentHelper.parseText((String)protoData);
        }
        catch (DocumentException e) {
            throw new YchException(E_ROOT_ELEMENT);
        }
        NetconfCodec codec = new NetconfCodec();
        Element rootElement = codec.getDataRootElement(document.getRootElement(), opType);
        if (rootElement == null) {
            throw new YchException(E_ROOT_KEY_ELEMENT);
        }
        YangRequestWorkBench extBuilder = new YangRequestWorkBench(rootElement.getName(), rootElement.getNamespaceURI(), opType, (YangSchemaRegistry)schemaReg, false);
        XmlCodecListener listener = new XmlCodecListener();
        listener.setYdtExtBuilder(extBuilder);
        DefaultXmlCodecWalker walker = new DefaultXmlCodecWalker();
        walker.walk(listener, rootElement, rootElement);
        return extBuilder;
    }
}

