/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yms.app.ych.YchException;
import org.onosproject.yms.ydt.YdtBuilder;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YdtType;

public final class DefaultCodecUtils {
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String URI_ENCODING_CHAR_SET = "ISO-8859-1";
    private static final String URI_NULL_CHECK_ERROR = "uri identifier should not be null";
    private static final String URI_MODULE_FORMAT = "Illegal URI, First node should be in format \"moduleName:nodeName\"";
    private static final String URI_LEAF_FORMAT = "Illegal URI, List or Leaf-list node should be in format \"nodeName=key\"or \"nodeName=instance-value\"";

    private DefaultCodecUtils() {
    }

    public static YdtBuilder convertUriToYdt(String identifier, YdtBuilder builder, YdtContextOperationType ydtOpType) {
        Preconditions.checkNotNull((Object)identifier, (Object)URI_NULL_CHECK_ERROR);
        List<String> segmentPaths = DefaultCodecUtils.urlPathArgsDecode(SLASH_SPLITTER.split((CharSequence)identifier));
        if (segmentPaths.isEmpty()) {
            return null;
        }
        DefaultCodecUtils.processPathSegments(segmentPaths, builder, ydtOpType);
        return builder;
    }

    private static YdtBuilder processPathSegments(List<String> paths, YdtBuilder builder, YdtContextOperationType ydtOpType) {
        if (paths.isEmpty()) {
            return builder;
        }
        boolean isLastNode = paths.size() == 1;
        YdtContextOperationType thisOpType = isLastNode ? ydtOpType : YdtContextOperationType.NONE;
        String path = paths.iterator().next();
        if (path.contains(COLON)) {
            DefaultCodecUtils.addModule(builder, path);
            DefaultCodecUtils.addNode(path, builder, thisOpType);
        } else if (path.contains(EQUAL)) {
            DefaultCodecUtils.addListOrLeafList(path, builder, thisOpType);
        } else {
            DefaultCodecUtils.addLeaf(path, builder, thisOpType);
        }
        if (isLastNode) {
            return builder;
        }
        List<String> remainPaths = paths.subList(1, paths.size());
        DefaultCodecUtils.processPathSegments(remainPaths, builder, ydtOpType);
        return builder;
    }

    private static YdtBuilder addModule(YdtBuilder builder, String path) {
        String moduleName = DefaultCodecUtils.getPreSegment(path, COLON);
        if (moduleName == null) {
            throw new YchException(URI_MODULE_FORMAT);
        }
        builder.addChild(moduleName, null, YdtType.SINGLE_INSTANCE_NODE);
        return builder;
    }

    private static YdtBuilder addNode(String path, YdtBuilder builder, YdtContextOperationType ydtOpType) {
        String nodeName = DefaultCodecUtils.getPostSegment(path, COLON);
        builder.addChild(nodeName, null, YdtType.SINGLE_INSTANCE_NODE, ydtOpType);
        return builder;
    }

    private static YdtBuilder addListOrLeafList(String path, YdtBuilder builder, YdtContextOperationType opType) {
        String nodeName = DefaultCodecUtils.getPreSegment(path, EQUAL);
        String keyStr = DefaultCodecUtils.getPostSegment(path, EQUAL);
        if (keyStr == null) {
            throw new YchException(URI_LEAF_FORMAT);
        }
        builder.setDefaultEditOperationType(opType);
        if (keyStr.contains(COMMA)) {
            ArrayList keys = Lists.newArrayList((Iterable)COMMA_SPLITTER.split((CharSequence)keyStr));
            builder.addMultiInstanceChild(nodeName, null, (List)keys, null);
        } else {
            builder.addMultiInstanceChild(nodeName, null, (List)Lists.newArrayList((Object[])new String[]{keyStr}), null);
        }
        return builder;
    }

    private static YdtBuilder addLeaf(String path, YdtBuilder builder, YdtContextOperationType ydtOpType) {
        Preconditions.checkNotNull((Object)path);
        builder.addChild(path, null, ydtOpType);
        return builder;
    }

    private static String getPreSegment(String path, String splitChar) {
        int idx = path.indexOf(splitChar);
        if (idx == -1) {
            return null;
        }
        if (path.indexOf(58, idx + 1) != -1) {
            return null;
        }
        return path.substring(0, idx);
    }

    private static String getPostSegment(String path, String splitChar) {
        int idx = path.indexOf(splitChar);
        if (idx == -1) {
            return path;
        }
        if (path.indexOf(splitChar, idx + 1) != -1) {
            return null;
        }
        return path.substring(idx + 1);
    }

    private static List<String> urlPathArgsDecode(Iterable<String> paths) {
        try {
            ArrayList<String> decodedPathArgs = new ArrayList<String>();
            for (String pathArg : paths) {
                String decode = URLDecoder.decode(pathArg, URI_ENCODING_CHAR_SET);
                decodedPathArgs.add(decode);
            }
            return decodedPathArgs;
        }
        catch (UnsupportedEncodingException e) {
            throw new YchException("Invalid URL path arg '" + paths + "': ", e);
        }
    }
}

