/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yms.app.ych.YchException;
import org.onosproject.yms.app.ych.defaultcodecs.YangCodecRegistry;
import org.onosproject.yms.app.ydt.YdtExtendedBuilder;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.yob.DefaultYobBuilder;
import org.onosproject.yms.app.yob.YobUtils;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.app.ytb.DefaultYangTreeBuilder;
import org.onosproject.yms.app.ytb.YtbException;
import org.onosproject.yms.ych.YangCodecHandler;
import org.onosproject.yms.ych.YangCompositeEncoding;
import org.onosproject.yms.ych.YangDataTreeCodec;
import org.onosproject.yms.ych.YangProtocolEncodingFormat;
import org.onosproject.yms.ydt.YdtBuilder;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YmsOperationType;
import org.onosproject.yms.ysr.YangModuleLibrary;

public class DefaultYangCodecHandler
implements YangCodecHandler {
    private static final String E_MODULE_LIST = "The input module or sub-module object list cannot be null.";
    private static final String E_DATA_TREE_CODEC = "data tree codec handler is null.";
    private static final String E_DATA_MODEL_CHILD = "Unable to find the child node";
    private static final String E_NOTIFICATION_NODE = "Notification node should be the first child of module in YDT";
    private final YangSchemaRegistry schemaRegistry;
    private YangModuleLibrary library;
    private final Map<YangProtocolEncodingFormat, YangDataTreeCodec> defaultCodecs = new HashMap<YangProtocolEncodingFormat, YangDataTreeCodec>();
    private final Map<YangProtocolEncodingFormat, YangDataTreeCodec> overrideCodecs = new HashMap<YangProtocolEncodingFormat, YangDataTreeCodec>();

    public DefaultYangCodecHandler(YangSchemaRegistry registry) {
        this.schemaRegistry = registry;
        Map<YangProtocolEncodingFormat, YangDataTreeCodec> recvCodec = YangCodecRegistry.getDefaultCodecs();
        if (!recvCodec.isEmpty()) {
            for (Map.Entry<YangProtocolEncodingFormat, YangDataTreeCodec> codecEntry : recvCodec.entrySet()) {
                this.defaultCodecs.put(codecEntry.getKey(), codecEntry.getValue());
            }
        }
    }

    private YangDataTreeCodec getAppropriateCodec(YangProtocolEncodingFormat dataFormat) {
        YangDataTreeCodec overrideCodec;
        YangDataTreeCodec codec = this.defaultCodecs.get(dataFormat);
        int size = this.overrideCodecs.size();
        if (size != 0 && (overrideCodec = this.overrideCodecs.get(dataFormat)) != null) {
            codec = overrideCodec;
        }
        return codec;
    }

    public void addDeviceSchema(Class<?> yangModule) {
        this.schemaRegistry.registerApplication(null, yangModule);
        this.schemaRegistry.processModuleLibrary(yangModule.getName(), this.library);
    }

    public String encodeOperation(String rootName, String rootNamespace, Map<String, String> tagAttrMap, List<Object> moduleList, YangProtocolEncodingFormat dataFormat, YmsOperationType opType) {
        if (moduleList == null || moduleList.isEmpty()) {
            throw new YchException(E_MODULE_LIST);
        }
        YangDataTreeCodec codec = this.getAppropriateCodec(dataFormat);
        if (codec == null) {
            throw new YchException(E_DATA_TREE_CODEC);
        }
        DefaultYangTreeBuilder builder = new DefaultYangTreeBuilder();
        YdtExtendedBuilder encodedYdt = builder.getYdtBuilderForYo(moduleList, rootName, rootNamespace, opType, this.schemaRegistry);
        encodedYdt.setRootTagAttributeMap(tagAttrMap);
        return codec.encodeYdtToProtocolFormat((YdtBuilder)encodedYdt);
    }

    public YangCompositeEncoding encodeCompositeOperation(String rootName, String rootNamespace, Object moduleObject, YangProtocolEncodingFormat dataFormat, YmsOperationType opType) {
        if (moduleObject == null) {
            throw new YtbException(E_MODULE_LIST);
        }
        YangDataTreeCodec codec = this.getAppropriateCodec(dataFormat);
        if (codec == null) {
            throw new YchException(E_DATA_TREE_CODEC);
        }
        ArrayList<Object> yangModuleList = new ArrayList<Object>();
        yangModuleList.add(moduleObject);
        DefaultYangTreeBuilder builder = new DefaultYangTreeBuilder();
        YdtExtendedBuilder extBuilder = builder.getYdtBuilderForYo(yangModuleList, rootName, rootNamespace, opType, this.schemaRegistry);
        return codec.encodeYdtToCompositeProtocolFormat((YdtBuilder)extBuilder);
    }

    public List<Object> decode(String inputString, YangProtocolEncodingFormat dataFormat, YmsOperationType opType) {
        YdtBuilder ydtBuilder;
        YangDataTreeCodec codec = this.getAppropriateCodec(dataFormat);
        if (codec == null) {
            throw new YchException(E_DATA_TREE_CODEC);
        }
        try {
            ydtBuilder = codec.decodeProtocolDataToYdt(inputString, (Object)this.schemaRegistry, opType);
        }
        catch (Exception e) {
            throw new YchException(e.getLocalizedMessage());
        }
        if (ydtBuilder != null) {
            return this.getObjectList(ydtBuilder.getRootNode());
        }
        return null;
    }

    public Object decode(YangCompositeEncoding protoData, YangProtocolEncodingFormat dataFormat, YmsOperationType opType) {
        YangDataTreeCodec codec = this.getAppropriateCodec(dataFormat);
        if (codec == null) {
            throw new YchException(E_DATA_TREE_CODEC);
        }
        YdtBuilder ydtBuilder = codec.decodeCompositeProtocolDataToYdt(protoData, (Object)this.schemaRegistry, opType);
        if (ydtBuilder == null) {
            return null;
        }
        YdtExtendedContext rootNode = (YdtExtendedContext)ydtBuilder.getRootNode();
        if (opType == YmsOperationType.NOTIFICATION) {
            return this.getNotificationObject((YdtExtendedContext)rootNode.getFirstChild());
        }
        return this.getObjectList(rootNode);
    }

    private Object getNotificationObject(YdtExtendedContext rootNode) {
        YangSchemaNodeContextInfo contextInfo;
        YangSchemaNode module = rootNode.getYangSchemaNode();
        YangSchemaNode childSchema = ((YdtExtendedContext)rootNode.getFirstChild()).getYangSchemaNode();
        YangSchemaNodeIdentifier id = new YangSchemaNodeIdentifier();
        id.setNameSpace(childSchema.getNameSpace());
        id.setName(childSchema.getName());
        try {
            contextInfo = module.getChildSchema(id);
        }
        catch (DataModelException e) {
            throw new YchException(E_DATA_MODEL_CHILD);
        }
        if (contextInfo == null) {
            throw new YchException(E_NOTIFICATION_NODE);
        }
        DefaultYobBuilder builder = new DefaultYobBuilder();
        Object object = builder.getYangObject((YdtExtendedContext)rootNode.getFirstChild(), this.schemaRegistry);
        Object eventSubObj = YobUtils.createAndSetInEventSubjectInstance(object, rootNode, this.schemaRegistry);
        return YobUtils.createAndSetInEventInstance(eventSubObj, rootNode, this.schemaRegistry);
    }

    public void registerOverriddenCodec(YangDataTreeCodec overrideCodec, YangProtocolEncodingFormat dataFormat) {
        this.overrideCodecs.put(dataFormat, overrideCodec);
    }

    private List<Object> getObjectList(YdtContext rootNode) {
        if (rootNode == null) {
            return null;
        }
        if (rootNode.getFirstChild() == null) {
            return null;
        }
        YdtContext curNode = rootNode.getFirstChild();
        DefaultYobBuilder builder = new DefaultYobBuilder();
        Object object = builder.getYangObject((YdtExtendedContext)curNode, this.schemaRegistry);
        ArrayList<Object> objectList = new ArrayList<Object>();
        objectList.add(object);
        while (curNode.getNextSibling() != null) {
            curNode = curNode.getNextSibling();
            object = builder.getYangObject((YdtExtendedContext)curNode, this.schemaRegistry);
            objectList.add(object);
        }
        return objectList;
    }

    public YangModuleLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(YangModuleLibrary library) {
        this.library = library;
    }
}

