/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.yab;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yms.app.utils.TraversalType;
import org.onosproject.yms.app.yab.exceptions.YabException;
import org.onosproject.yms.app.ydt.AppNodeFactory;
import org.onosproject.yms.app.ydt.DefaultYdtAppContext;
import org.onosproject.yms.app.ydt.YangRequestWorkBench;
import org.onosproject.yms.app.ydt.YangResponseWorkBench;
import org.onosproject.yms.app.ydt.YdtAppContext;
import org.onosproject.yms.app.ydt.YdtAppNodeOperationType;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ydt.YdtMultiInstanceNode;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.yob.DefaultYobBuilder;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.app.ytb.DefaultYangTreeBuilder;
import org.onosproject.yms.ydt.YdtBuilder;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YdtResponse;
import org.onosproject.yms.ydt.YmsOperationExecutionStatus;

public class YangApplicationBroker {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String AUGMENTED = "Augmented";
    private static final String VOID = "void";
    private final YangSchemaRegistry schemaRegistry;
    private Set<String> augGenMethodSet;

    public YangApplicationBroker(YangSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public YdtResponse processQuery(YdtBuilder ydtWorkBench) throws YabException {
        LinkedList<Object> responseObjects = new LinkedList<Object>();
        YangRequestWorkBench workBench = (YangRequestWorkBench)ydtWorkBench;
        this.augGenMethodSet = ((YangRequestWorkBench)ydtWorkBench).getAugGenMethodSet();
        for (YdtAppContext appContext = workBench.getAppRootNode().getFirstChild(); appContext != null; appContext = appContext.getNextSibling()) {
            Object responseObject = this.processQueryOfApplication(appContext);
            if (responseObject == null) continue;
            responseObjects.add(responseObject);
        }
        YdtExtendedContext rootYdtContext = workBench.getRootNode();
        YdtBuilder responseYdt = this.buildResponseYdt(responseObjects, rootYdtContext.getName(), rootYdtContext.getNamespace());
        return new YangResponseWorkBench(responseYdt.getRootNode(), YmsOperationExecutionStatus.EXECUTION_SUCCESS, ydtWorkBench.getYmsOperationType());
    }

    public YdtResponse processEdit(YdtBuilder ydtWorkBench) throws CloneNotSupportedException, YabException {
        YangRequestWorkBench workBench = (YangRequestWorkBench)ydtWorkBench;
        this.augGenMethodSet = ((YangRequestWorkBench)ydtWorkBench).getAugGenMethodSet();
        for (YdtAppContext appContext = workBench.getAppRootNode().getFirstChild(); appContext != null; appContext = appContext.getNextSibling()) {
            this.processEditOfApplication(appContext);
        }
        return new YangResponseWorkBench(null, YmsOperationExecutionStatus.EXECUTION_SUCCESS, workBench.getYmsOperationType());
    }

    public YdtResponse processOperation(YdtBuilder ydtWorkBench) throws YabException {
        YangRequestWorkBench workBench = (YangRequestWorkBench)ydtWorkBench;
        YdtAppContext appContext = workBench.getAppRootNode().getFirstChild();
        for (YdtContext ydtNode = appContext.getModuleContext(); ydtNode != null; ydtNode = ydtNode.getNextSibling()) {
            YdtContext childYdtNode = ydtNode.getFirstChild();
            YangSchemaNode yangNode = ((YdtNode)childYdtNode).getYangSchemaNode();
            if (!(yangNode instanceof YangRpc)) continue;
            return this.processRpcOperationOfApplication(childYdtNode, appContext, yangNode, workBench);
        }
        return new YangResponseWorkBench(null, YmsOperationExecutionStatus.EXECUTION_SUCCESS, ydtWorkBench.getYmsOperationType());
    }

    private YdtResponse processRpcOperationOfApplication(YdtContext rpcYdt, YdtAppContext appContext, YangSchemaNode yangRpc, YangRequestWorkBench workBench) throws YabException {
        Object inputObject = null;
        YdtContext inputYdtNode = this.getInputYdtNode(rpcYdt);
        if (inputYdtNode != null) {
            inputObject = this.getYangObject(inputYdtNode);
        }
        Object appObject = this.getApplicationObjectForRpc(appContext);
        String methodName = yangRpc.getJavaClassNameOrBuiltInType();
        Object outputObject = this.invokeRpcApplicationsMethod(appObject, inputObject, methodName);
        String returnType = this.getReturnTypeOfRpcResponse(appObject, inputObject, yangRpc);
        if (!returnType.equals(VOID)) {
            YdtBuilder responseYdt = this.buildRpcResponseYdt(outputObject, workBench);
            return new YangResponseWorkBench(responseYdt.getRootNode(), YmsOperationExecutionStatus.EXECUTION_SUCCESS, workBench.getYmsOperationType());
        }
        return new YangResponseWorkBench(null, YmsOperationExecutionStatus.EXECUTION_SUCCESS, workBench.getYmsOperationType());
    }

    private Object processQueryOfApplication(YdtAppContext appContext) throws YabException {
        YdtContext ydtNode = appContext.getModuleContext();
        YangNode yangNode = (YangNode)appContext.getYangSchemaNode();
        if (yangNode.isDescendantNodeAugmented()) {
            this.processAugmentForChildNode(appContext, yangNode);
        }
        String appName = this.getCapitalCase(((YdtNode)appContext.getModuleContext()).getYangSchemaNode().getJavaClassNameOrBuiltInType());
        Object outputObject = this.getYangObject(ydtNode);
        TraversalType curTraversal = TraversalType.ROOT;
        do {
            if (curTraversal != TraversalType.PARENT) {
                Object appManagerObject = this.getApplicationObject(appContext);
                String methodName = this.getApplicationMethodName(appContext, appName, GET);
                String moduleName = appContext.getAppData().getRootSchemaNode().getName();
                outputObject = this.invokeApplicationsMethod(appManagerObject, outputObject, methodName, moduleName);
            }
            if (curTraversal != TraversalType.PARENT && appContext.getFirstChild() != null) {
                curTraversal = TraversalType.CHILD;
                appContext = appContext.getFirstChild();
                continue;
            }
            if (appContext.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                appContext = appContext.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            if (appContext.getParent().getParent() == null) continue;
            appContext = appContext.getParent();
        } while (appContext.getParent().getParent() != null);
        return outputObject;
    }

    private void processEditOfApplication(YdtAppContext appContext) throws CloneNotSupportedException, YabException {
        if (appContext.getOperationType() != YdtAppNodeOperationType.OTHER_EDIT) {
            this.processDeleteRequestOfApplication(appContext);
        }
        if (appContext.getOperationType() != YdtAppNodeOperationType.DELETE_ONLY) {
            YdtContext ydtNode = appContext.getModuleContext();
            String appName = this.getCapitalCase(((YdtNode)appContext.getModuleContext()).getYangSchemaNode().getJavaClassNameOrBuiltInType());
            Object outputObject = this.getYangObject(ydtNode);
            TraversalType curTraversal = TraversalType.ROOT;
            do {
                if (curTraversal != TraversalType.PARENT) {
                    Object appManagerObject = this.getApplicationObject(appContext);
                    String methodName = this.getApplicationMethodName(appContext, appName, SET);
                    String moduleName = appContext.getAppData().getRootSchemaNode().getName();
                    this.invokeApplicationsMethod(appManagerObject, outputObject, methodName, moduleName);
                }
                if (curTraversal != TraversalType.PARENT && appContext.getFirstChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    appContext = appContext.getFirstChild();
                    continue;
                }
                if (appContext.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBLING;
                    appContext = appContext.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                if (appContext.getParent().getParent() == null) continue;
                appContext = appContext.getParent();
            } while (appContext.getParent().getParent() != null);
        }
    }

    private void processDeleteRequestOfApplication(YdtAppContext appContext) throws CloneNotSupportedException, YabException {
        TraversalType curTraversal = TraversalType.ROOT;
        List<YdtContext> deleteNodes = appContext.getDeleteNodes();
        if (deleteNodes != null && !deleteNodes.isEmpty()) {
            YdtContext deleteTree = this.buildDeleteTree(deleteNodes);
            this.processAugmentedNodesForDelete(deleteTree.getFirstChild(), appContext);
            Object inputObject = this.getYangObject(deleteTree.getFirstChild());
            String appName = this.getCapitalCase(((YdtNode)appContext.getModuleContext()).getYangSchemaNode().getJavaClassNameOrBuiltInType());
            do {
                if (curTraversal == TraversalType.ROOT || curTraversal == TraversalType.SIBLING) {
                    while (appContext.getLastChild() != null) {
                        appContext = appContext.getLastChild();
                    }
                }
                Object appManagerObject = this.getApplicationObject(appContext);
                String methodName = this.getApplicationMethodName(appContext, appName, SET);
                String moduleName = appContext.getAppData().getRootSchemaNode().getName();
                this.invokeApplicationsMethod(appManagerObject, inputObject, methodName, moduleName);
                if (appContext.getPreviousSibling() != null) {
                    curTraversal = TraversalType.SIBLING;
                    appContext = appContext.getPreviousSibling();
                    continue;
                }
                if (appContext.getParent() == null) continue;
                curTraversal = TraversalType.PARENT;
                appContext = appContext.getParent();
            } while (appContext.getParent() != null);
        }
    }

    protected void processAugmentForChildNode(YdtAppContext curAppContext, YangNode schemaNode) {
        YangNode yangNode = schemaNode.getChild();
        if (yangNode == null) {
            return;
        }
        TraversalType curTraversal = TraversalType.CHILD;
        while (!yangNode.equals(schemaNode)) {
            if (curTraversal != TraversalType.PARENT && yangNode instanceof YangAugmentableNode && !((YangAugmentableNode)yangNode).getAugmentedInfoList().isEmpty()) {
                this.updateAppTreeWithAugmentNodes(yangNode, curAppContext);
            }
            if (curTraversal != TraversalType.PARENT && yangNode.getChild() != null && yangNode.isDescendantNodeAugmented()) {
                curTraversal = TraversalType.CHILD;
                yangNode = yangNode.getChild();
                continue;
            }
            if (yangNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                yangNode = yangNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            yangNode = yangNode.getParent();
        }
    }

    protected void processAugmentedNodesForDelete(YdtContext deleteTree, YdtAppContext appContext) {
        TraversalType curTraversal = TraversalType.ROOT;
        YdtContext ydtContext = deleteTree.getFirstChild();
        if (ydtContext == null) {
            YangNode yangNode = (YangNode)((YdtNode)deleteTree).getYangSchemaNode();
            if (yangNode.isDescendantNodeAugmented()) {
                this.processAugmentForChildNode(appContext, yangNode);
            }
            return;
        }
        while (!ydtContext.equals(deleteTree)) {
            if (curTraversal != TraversalType.PARENT && ((YdtNode)ydtContext).getYdtContextOperationType() == YdtContextOperationType.DELETE) {
                YangNode yangNode = (YangNode)((YdtNode)ydtContext).getYangSchemaNode();
                if (yangNode instanceof YangAugmentableNode) {
                    this.updateAppTreeWithAugmentNodes(yangNode, appContext);
                }
                if (yangNode.isDescendantNodeAugmented()) {
                    this.processAugmentForChildNode(appContext, yangNode);
                }
            }
            if (curTraversal != TraversalType.PARENT && ydtContext.getFirstChild() != null) {
                curTraversal = TraversalType.CHILD;
                ydtContext = ydtContext.getFirstChild();
                continue;
            }
            if (ydtContext.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                ydtContext = ydtContext.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            ydtContext = ydtContext.getParent();
        }
    }

    private YdtBuilder buildResponseYdt(List<Object> responseObjects, String name, String namespace) {
        DefaultYangTreeBuilder treeBuilder = new DefaultYangTreeBuilder();
        return treeBuilder.getYdtBuilderForYo(responseObjects, name, namespace, null, this.schemaRegistry);
    }

    private YdtBuilder buildRpcResponseYdt(Object responseObject, YangRequestWorkBench requestWorkBench) {
        DefaultYangTreeBuilder treeBuilder = new DefaultYangTreeBuilder();
        return treeBuilder.getYdtForRpcResponse(responseObject, requestWorkBench);
    }

    protected YdtContext buildDeleteTree(List<YdtContext> deleteNodes) throws CloneNotSupportedException {
        Iterator<YdtContext> iterator = deleteNodes.iterator();
        YdtContext deleteTree = null;
        while (iterator.hasNext()) {
            YdtContext deleteNode = iterator.next();
            if (((YdtExtendedContext)deleteNode.getParent()).getYdtContextOperationType() == YdtContextOperationType.DELETE) continue;
            this.cloneAncestorsOfDeleteNode(deleteNode);
            deleteTree = this.unlinkDeleteNodeFromCurrentTree((YdtNode)deleteNode);
        }
        if (deleteTree != null) {
            while (deleteTree.getParent() != null) {
                deleteTree = deleteTree.getParent();
            }
        }
        return deleteTree;
    }

    private void cloneAncestorsOfDeleteNode(YdtContext deleteNode) throws CloneNotSupportedException {
        YdtNode previousNode = null;
        for (YdtNode nodeToClone = (YdtNode)deleteNode.getParent(); nodeToClone != null; nodeToClone = nodeToClone.getParent()) {
            YdtNode clonedNode;
            if (nodeToClone.getClonedNode() == null) {
                clonedNode = nodeToClone.clone();
                this.unlinkCurrentYdtNode(clonedNode);
                if (nodeToClone instanceof YdtMultiInstanceNode) {
                    this.addKeyLeavesToClonedNode(nodeToClone, clonedNode);
                }
                nodeToClone.setClonedNode(clonedNode);
            } else {
                clonedNode = (YdtNode)nodeToClone.getClonedNode();
            }
            if (previousNode != null) {
                clonedNode.addChild(previousNode, false);
            }
            previousNode = clonedNode;
        }
    }

    private YdtNode unlinkDeleteNodeFromCurrentTree(YdtNode deleteNode) {
        YdtNode parentClonedNode = (YdtNode)deleteNode.getParent().getClonedNode();
        this.unlinkNodeFromParent(deleteNode);
        this.unlinkNodeFromSibling(deleteNode);
        deleteNode.setParent(null);
        deleteNode.setPreviousSibling(null);
        deleteNode.setNextSibling(null);
        parentClonedNode.addChild(deleteNode, false);
        return deleteNode;
    }

    private void addKeyLeavesToClonedNode(YdtNode curNode, YdtNode clonedNode) throws CloneNotSupportedException {
        List<YdtContext> keyList = ((YdtMultiInstanceNode)curNode).getKeyNodeList();
        if (keyList != null && !keyList.isEmpty()) {
            for (YdtContext keyLeaf : keyList) {
                YdtNode keyClonedLeaf = ((YdtNode)keyLeaf).clone();
                this.unlinkCurrentYdtNode(keyClonedLeaf);
                clonedNode.addChild(keyClonedLeaf, true);
            }
        }
    }

    private void updateAppTreeWithAugmentNodes(YangNode yangNode, YdtAppContext curAppContext) {
        for (YangAugment yangAugment : ((YangAugmentableNode)yangNode).getAugmentedInfoList()) {
            Object appManagerObject = this.schemaRegistry.getRegisteredApplication((YangSchemaNode)yangAugment.getParent());
            if (appManagerObject == null || !this.augGenMethodSet.add(yangAugment.getSetterMethodName())) continue;
            YdtAppContext childAppContext = this.addChildToYdtAppTree(curAppContext, (YangNode)yangAugment);
            this.processAugmentForChildNode(childAppContext, (YangNode)yangAugment);
        }
    }

    private YdtAppContext addChildToYdtAppTree(YdtAppContext curAppContext, YangNode augment) {
        DefaultYdtAppContext childAppContext = AppNodeFactory.getAppContext(true);
        childAppContext.setParent(curAppContext);
        childAppContext.setOperationType(curAppContext.getOperationType());
        childAppContext.setAugmentingSchemaNode((YangSchemaNode)augment);
        curAppContext.addChild(childAppContext);
        return childAppContext;
    }

    private void unlinkNodeFromParent(YdtNode deleteNode) {
        YdtNode parentNode = deleteNode.getParent();
        if (parentNode.getFirstChild().equals(deleteNode) && parentNode.getLastChild().equals(deleteNode)) {
            parentNode.setChild(null);
            parentNode.setLastChild(null);
        } else if (parentNode.getFirstChild().equals(deleteNode)) {
            parentNode.setChild(deleteNode.getNextSibling());
        } else if (parentNode.getLastChild().equals(deleteNode)) {
            parentNode.setLastChild(deleteNode.getPreviousSibling());
        }
    }

    private void unlinkNodeFromSibling(YdtNode deleteNode) {
        YdtNode previousSibling = deleteNode.getPreviousSibling();
        YdtNode nextSibling = deleteNode.getNextSibling();
        if (nextSibling != null && previousSibling != null) {
            previousSibling.setNextSibling(nextSibling);
            nextSibling.setPreviousSibling(previousSibling);
        } else if (nextSibling != null) {
            nextSibling.setPreviousSibling(null);
        } else if (previousSibling != null) {
            previousSibling.setNextSibling(null);
        }
    }

    private void unlinkCurrentYdtNode(YdtNode ydtNode) {
        ydtNode.setParent(null);
        ydtNode.setNextSibling(null);
        ydtNode.setPreviousSibling(null);
        ydtNode.setChild(null);
        ydtNode.setLastChild(null);
    }

    private Object getYangObject(YdtContext ydtNode) {
        Preconditions.checkNotNull((Object)ydtNode);
        DefaultYobBuilder yobBuilder = new DefaultYobBuilder();
        return yobBuilder.getYangObject((YdtExtendedContext)ydtNode, this.schemaRegistry);
    }

    private Object getApplicationObjectForRpc(YdtAppContext appContext) {
        Preconditions.checkNotNull((Object)appContext);
        while (appContext.getFirstChild() != null) {
            appContext = appContext.getFirstChild();
        }
        return this.schemaRegistry.getRegisteredApplication(appContext.getAppData().getRootSchemaNode());
    }

    private Object getApplicationObject(YdtAppContext appContext) {
        return this.schemaRegistry.getRegisteredApplication(appContext.getAppData().getRootSchemaNode());
    }

    private String getCapitalCase(String yangIdentifier) {
        return yangIdentifier.substring(0, 1).toUpperCase() + yangIdentifier.substring(1);
    }

    private String getApplicationMethodName(YdtAppContext appContext, String appName, String operation) {
        if (appContext.getYangSchemaNode() instanceof YangModule) {
            return operation + appName;
        }
        String augment = ((YangAtomicPath)((YangAugment)appContext.getAugmentingSchemaNode()).getTargetNode().get(0)).getResolvedNode().getJavaClassNameOrBuiltInType();
        return operation + AUGMENTED + appName + this.getCapitalCase(augment);
    }

    private YdtContext getInputYdtNode(YdtContext rpcNode) {
        YdtContext inputNode = rpcNode.getFirstChild();
        while (inputNode != null) {
            YangSchemaNode yangInputNode = ((YdtNode)inputNode).getYangSchemaNode();
            if (yangInputNode instanceof YangInput) {
                return inputNode;
            }
            inputNode = rpcNode.getNextSibling();
        }
        return null;
    }

    private Object invokeApplicationsMethod(Object appManagerObject, Object inputObject, String methodName, String appName) throws YabException {
        Preconditions.checkNotNull((Object)appManagerObject);
        Class<?> appClass = appManagerObject.getClass();
        try {
            Method methodObject = appClass.getDeclaredMethod(methodName, inputObject.getClass());
            if (methodObject != null) {
                return methodObject.invoke(appManagerObject, inputObject);
            }
            throw new YabException("No such method in application");
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new YabException(e);
        }
        catch (InvocationTargetException e) {
            throw new YabException("Invocation exception in service " + appName, e.getCause());
        }
    }

    private String getReturnTypeOfRpcResponse(Object appObject, Object inputObject, YangSchemaNode yangNode) throws YabException {
        Method methodObject = null;
        try {
            methodObject = inputObject == null ? appObject.getClass().getDeclaredMethod(yangNode.getJavaClassNameOrBuiltInType(), null) : appObject.getClass().getDeclaredMethod(yangNode.getJavaClassNameOrBuiltInType(), inputObject.getClass().getInterfaces());
            if (methodObject != null) {
                return methodObject.getReturnType().getSimpleName();
            }
            throw new YabException("No such method in application");
        }
        catch (NoSuchMethodException e) {
            throw new YabException(e);
        }
    }

    private Object invokeRpcApplicationsMethod(Object appManagerObject, Object inputParamObject, String methodName) throws YabException {
        Preconditions.checkNotNull((Object)appManagerObject);
        Class<?> appClass = appManagerObject.getClass();
        try {
            if (inputParamObject == null) {
                Method methodObject = appClass.getDeclaredMethod(methodName, null);
                if (methodObject != null) {
                    return methodObject.invoke(appManagerObject, new Object[0]);
                }
            } else {
                Method methodObject = appClass.getDeclaredMethod(methodName, inputParamObject.getClass().getInterfaces());
                if (methodObject != null) {
                    return methodObject.invoke(appManagerObject, inputParamObject);
                }
            }
            throw new YabException("No such method in application");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new YabException(e);
        }
    }

    public void setAugGenMethodSet(Set<String> augGenMethodSet) {
        this.augGenMethodSet = augGenMethodSet;
    }
}

