/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.restconf.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.restconf.api.RestconfException;
import org.onosproject.restconf.utils.exceptions.RestconfUtilsException;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.DefaultCompositeData;
import org.onosproject.yang.runtime.DefaultCompositeStream;
import org.onosproject.yang.runtime.DefaultRuntimeContext;
import org.onosproject.yang.runtime.RuntimeContext;
import org.onosproject.yang.runtime.YangRuntimeService;

public final class RestconfUtils {
    private static final String JSON_FORMAT = "JSON";
    private static final YangRuntimeService YANG_RUNTIME = (YangRuntimeService)DefaultServiceDirectory.getService(YangRuntimeService.class);

    private RestconfUtils() {
    }

    public static ObjectNode convertInputStreamToObjectNode(InputStream inputStream) {
        ObjectNode rootNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = (ObjectNode)mapper.readTree(inputStream);
        }
        catch (IOException e) {
            throw new RestconfUtilsException("ERROR: InputStream failed to parse");
        }
        return rootNode;
    }

    public static InputStream convertObjectNodeToInputStream(ObjectNode rootNode) {
        InputStream inputStream;
        String json = rootNode.toString();
        try {
            inputStream = IOUtils.toInputStream((String)json);
        }
        catch (Exception e) {
            throw new RestconfUtilsException("ERROR: Json Node failed to parse");
        }
        return inputStream;
    }

    public static ResourceId convertUriToRid(String uri) {
        ResourceData resourceData = RestconfUtils.convertJsonToDataNode(uri, null);
        return resourceData.resourceId();
    }

    public static ResourceData convertJsonToDataNode(String uri, ObjectNode rootNode) {
        DefaultRuntimeContext.Builder runtimeContextBuilder = new DefaultRuntimeContext.Builder();
        runtimeContextBuilder.setDataFormat(JSON_FORMAT);
        RuntimeContext context = runtimeContextBuilder.build();
        InputStream jsonData = null;
        if (rootNode != null) {
            jsonData = RestconfUtils.convertObjectNodeToInputStream(rootNode);
        }
        DefaultCompositeStream compositeStream = new DefaultCompositeStream(uri, jsonData);
        CompositeData compositeData = YANG_RUNTIME.decode((CompositeStream)compositeStream, context);
        ResourceData resourceData = compositeData.resourceData();
        return resourceData;
    }

    public static ObjectNode convertDataNodeToJson(ResourceId rid, DataNode dataNode) {
        DefaultRuntimeContext.Builder runtimeContextBuilder = DefaultRuntimeContext.builder();
        runtimeContextBuilder.setDataFormat(JSON_FORMAT);
        RuntimeContext context = runtimeContextBuilder.build();
        DefaultResourceData.Builder resourceDataBuilder = DefaultResourceData.builder();
        resourceDataBuilder.addDataNode(dataNode);
        resourceDataBuilder.resourceId(rid);
        ResourceData resourceData = resourceDataBuilder.build();
        DefaultCompositeData.Builder compositeDataBuilder = DefaultCompositeData.builder();
        compositeDataBuilder.resourceData(resourceData);
        CompositeData compositeData = compositeDataBuilder.build();
        CompositeStream compositeStream = YANG_RUNTIME.encode(compositeData, context);
        InputStream inputStream = compositeStream.resourceData();
        ObjectNode rootNode = RestconfUtils.convertInputStreamToObjectNode(inputStream);
        if (rootNode == null) {
            throw new RestconfException("ERROR: InputStream can not be convert to ObjectNode", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return rootNode;
    }
}

