/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.driver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.IpAddress;
import org.onosproject.net.Device;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleHandler;
import org.onosproject.openflow.controller.driver.RoleRecvStatus;
import org.onosproject.openflow.controller.driver.RoleReplyInfo;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.projectfloodlight.openflow.protocol.OFMeterFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRoleRequest;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFRoleReply;
import org.projectfloodlight.openflow.protocol.OFRoleRequest;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenFlowSwitch
extends AbstractHandlerBehaviour
implements OpenFlowSwitchDriver {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Channel channel;
    protected String channelId;
    private boolean connected;
    protected boolean startDriverHandshakeCalled = false;
    private Dpid dpid;
    private OpenFlowAgent agent;
    private final AtomicInteger xidCounter = new AtomicInteger(0);
    private OFVersion ofVersion;
    protected List<OFPortDescStatsReply> ports = new ArrayList<OFPortDescStatsReply>();
    protected boolean tableFull;
    private RoleHandler roleMan;
    protected volatile RoleState role;
    protected OFFeaturesReply features;
    protected OFDescStatsReply desc;
    protected OFMeterFeaturesStatsReply meterfeatures;
    private final AtomicReference<List<OFMessage>> messagesPendingMastership = new AtomicReference();

    @Override
    public void init(Dpid dpid, OFDescStatsReply desc, OFVersion ofv) {
        this.dpid = dpid;
        this.desc = desc;
        this.ofVersion = ofv;
    }

    @Override
    public final void disconnectSwitch() {
        this.setConnected(false);
        this.channel.close();
    }

    @Override
    public void sendMsg(OFMessage msg) {
        this.sendMsg(Collections.singletonList(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendMsg(List<OFMessage> msgs) {
        if (this.role == RoleState.MASTER) {
            this.sendMsgsOnChannel(msgs);
            return;
        }
        AtomicReference<List<OFMessage>> atomicReference = this.messagesPendingMastership;
        synchronized (atomicReference) {
            if (this.role == RoleState.MASTER) {
                this.sendMsgsOnChannel(msgs);
                return;
            }
            List<OFMessage> messages = this.messagesPendingMastership.get();
            if (messages != null) {
                messages.addAll(msgs);
                this.log.debug("Enqueue message for switch {}. queue size after is {}", (Object)this.dpid, (Object)messages.size());
            } else {
                this.log.warn("Dropping message for switch {} (role: {}, connected: {}): {}", new Object[]{this.dpid, this.role, this.channel.isConnected(), msgs});
            }
        }
    }

    private void sendMsgsOnChannel(List<OFMessage> msgs) {
        if (this.channel.isConnected()) {
            this.channel.write(msgs);
            this.agent.processDownstreamMessage(this.dpid, msgs);
        } else {
            this.log.warn("Dropping messages for switch {} because channel is not connected: {}", (Object)this.dpid, msgs);
        }
    }

    @Override
    public final void sendRoleRequest(OFMessage msg) {
        if (msg instanceof OFRoleRequest || msg instanceof OFNiciraControllerRoleRequest) {
            this.sendMsgsOnChannel(Collections.singletonList(msg));
            return;
        }
        throw new IllegalArgumentException("Someone is trying to send a non role request message");
    }

    @Override
    public final void sendHandshakeMessage(OFMessage message) {
        if (!this.isDriverHandshakeComplete()) {
            this.sendMsgsOnChannel(Collections.singletonList(message));
        }
    }

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
            this.channelId = ipAddress.isIp4() ? ipAddress.toString() + ':' + inetAddress.getPort() : '[' + ipAddress.toString() + "]:" + inetAddress.getPort();
        }
    }

    @Override
    public String channelId() {
        return this.channelId;
    }

    @Override
    public final long getId() {
        return this.dpid.value();
    }

    @Override
    public final String getStringId() {
        return this.dpid.toString();
    }

    @Override
    public final void setOFVersion(OFVersion ofV) {
        this.ofVersion = ofV;
    }

    @Override
    public void setTableFull(boolean full) {
        this.tableFull = full;
    }

    @Override
    public void setFeaturesReply(OFFeaturesReply featuresReply) {
        this.features = featuresReply;
    }

    @Override
    public void setMeterFeaturesReply(OFMeterFeaturesStatsReply meterFeaturesReply) {
        this.meterfeatures = meterFeaturesReply;
    }

    @Override
    public abstract Boolean supportNxRole();

    @Override
    public final void handleMessage(OFMessage m) {
        if (this.role == RoleState.MASTER || m instanceof OFPortStatus) {
            this.agent.processMessage(this.dpid, m);
        } else {
            this.log.trace("Dropping received message {}, was not MASTER", (Object)m);
        }
    }

    @Override
    public RoleState getRole() {
        return this.role;
    }

    @Override
    public final boolean connectSwitch() {
        return this.agent.addConnectedSwitch(this.dpid, this);
    }

    @Override
    public final boolean activateMasterSwitch() {
        return this.agent.addActivatedMasterSwitch(this.dpid, this);
    }

    @Override
    public final boolean activateEqualSwitch() {
        return this.agent.addActivatedEqualSwitch(this.dpid, this);
    }

    @Override
    public final void transitionToEqualSwitch() {
        this.agent.transitionToEqualSwitch(this.dpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transitionToMasterSwitch() {
        this.agent.transitionToMasterSwitch(this.dpid);
        AtomicReference<List<OFMessage>> atomicReference = this.messagesPendingMastership;
        synchronized (atomicReference) {
            List<OFMessage> messages = this.messagesPendingMastership.get();
            if (messages != null) {
                this.sendMsgsOnChannel(messages);
                this.log.debug("Sending {} pending messages to switch {}", (Object)messages.size(), (Object)this.dpid);
                this.messagesPendingMastership.set(null);
            }
            this.role = RoleState.MASTER;
        }
    }

    @Override
    public final void removeConnectedSwitch() {
        this.agent.removeConnectedSwitch(this.dpid);
    }

    @Override
    public OFFactory factory() {
        return OFFactories.getFactory((OFVersion)this.ofVersion);
    }

    @Override
    public void setPortDescReply(OFPortDescStatsReply portDescReply) {
        this.ports.add(portDescReply);
    }

    @Override
    public void setPortDescReplies(List<OFPortDescStatsReply> portDescReplies) {
        this.ports.addAll(portDescReplies);
    }

    @Override
    public void returnRoleReply(RoleState requested, RoleState response) {
        this.agent.returnRoleReply(this.dpid, requested, response);
    }

    @Override
    public abstract void startDriverHandshake();

    @Override
    public abstract boolean isDriverHandshakeComplete();

    @Override
    public abstract void processDriverHandshakeMessage(OFMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRole(RoleState role) {
        block9: {
            try {
                if (role == RoleState.SLAVE || role == RoleState.EQUAL) {
                    this.role = role;
                }
                if (this.roleMan.sendRoleRequest(role, RoleRecvStatus.MATCHED_SET_ROLE)) {
                    this.log.debug("Sending role {} to switch {}", (Object)role, (Object)this.getStringId());
                    if (role != RoleState.MASTER) break block9;
                    AtomicReference<List<OFMessage>> atomicReference = this.messagesPendingMastership;
                    synchronized (atomicReference) {
                        if (this.messagesPendingMastership.get() == null) {
                            this.log.debug("Initializing new message queue for switch {}", (Object)this.dpid);
                            this.messagesPendingMastership.set(Lists.newArrayList());
                        }
                        break block9;
                    }
                }
                if (role == RoleState.MASTER) {
                    this.role = role;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to write to switch {}.", (Object)this.dpid);
            }
        }
    }

    @Override
    public void reassertRole() {
        if (this.getRole() == RoleState.MASTER) {
            this.log.warn("Received permission error from switch {} while being master. Reasserting master role.", (Object)this.getStringId());
            this.setRole(RoleState.MASTER);
        }
    }

    @Override
    public void handleRole(OFMessage m) throws SwitchStateException {
        RoleReplyInfo rri = this.roleMan.extractOFRoleReply((OFRoleReply)m);
        RoleRecvStatus rrs = this.roleMan.deliverRoleReply(rri);
        if (rrs == RoleRecvStatus.MATCHED_SET_ROLE) {
            if (rri.getRole() == RoleState.MASTER) {
                this.transitionToMasterSwitch();
            } else if (rri.getRole() == RoleState.EQUAL || rri.getRole() == RoleState.SLAVE) {
                this.transitionToEqualSwitch();
            }
        } else {
            this.log.warn("Failed to set role for {}", (Object)this.getStringId());
        }
    }

    @Override
    public void handleNiciraRole(OFMessage m) throws SwitchStateException {
        RoleState r = this.roleMan.extractNiciraRoleReply((OFExperimenter)m);
        if (r == null) {
            this.handleMessage(m);
            return;
        }
        RoleRecvStatus rrs = this.roleMan.deliverRoleReply(new RoleReplyInfo(r, null, m.getXid()));
        if (rrs == RoleRecvStatus.MATCHED_SET_ROLE) {
            if (r == RoleState.MASTER) {
                this.transitionToMasterSwitch();
            } else if (r == RoleState.EQUAL || r == RoleState.SLAVE) {
                this.transitionToEqualSwitch();
            }
        } else {
            this.disconnectSwitch();
        }
    }

    @Override
    public boolean handleRoleError(OFErrorMsg error) {
        try {
            return RoleRecvStatus.OTHER_EXPECTATION != this.roleMan.deliverError(error);
        }
        catch (SwitchStateException e) {
            this.disconnectSwitch();
            return true;
        }
    }

    @Override
    public final void setAgent(OpenFlowAgent ag) {
        if (this.agent == null) {
            this.agent = ag;
        }
    }

    @Override
    public final void setRoleHandler(RoleHandler roleHandler) {
        if (this.roleMan == null) {
            this.roleMan = roleHandler;
        }
    }

    @Override
    public void setSwitchDescription(OFDescStatsReply d) {
        this.desc = d;
    }

    @Override
    public int getNextTransactionId() {
        return this.xidCounter.getAndIncrement();
    }

    @Override
    public List<OFPortDesc> getPorts() {
        return this.ports.stream().flatMap(portReply -> portReply.getEntries().stream()).collect(Collectors.toList());
    }

    @Override
    public OFMeterFeatures getMeterFeatures() {
        if (this.meterfeatures != null) {
            return this.meterfeatures.getFeatures();
        }
        return null;
    }

    @Override
    public String manufacturerDescription() {
        return this.desc.getMfrDesc();
    }

    @Override
    public String datapathDescription() {
        return this.desc.getDpDesc();
    }

    @Override
    public String hardwareDescription() {
        return this.desc.getHwDesc();
    }

    @Override
    public String softwareDescription() {
        return this.desc.getSwDesc();
    }

    @Override
    public String serialNumber() {
        return this.desc.getSerialNum();
    }

    @Override
    public Device.Type deviceType() {
        return Device.Type.SWITCH;
    }

    public String toString() {
        return this.getClass().getName() + " [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }
}

