/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.onlab.util.Tools;
import org.onosproject.drivers.utilities.YangElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangXmlUtils {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private static YangXmlUtils instance = null;

    protected YangXmlUtils() {
    }

    public XMLConfiguration getXmlConfiguration(String file, Map<String, String> values) {
        InputStream stream = this.getCfgInputStream(file);
        XMLConfiguration cfg = this.loadXml(stream);
        XMLConfiguration complete = new XMLConfiguration();
        ArrayList paths = new ArrayList();
        HashMap valuesWithKey = new HashMap();
        values.keySet().forEach(path -> {
            List<String> allPaths = this.findPaths((HierarchicalConfiguration)cfg, (String)path);
            String key = (String)Tools.nullIsNotFound(allPaths.isEmpty() ? null : allPaths.get(0), (String)"Yang model does not contain desired path");
            paths.add(key);
            valuesWithKey.put(key, values.get(path));
        });
        Collections.sort(paths, new StringLengthComparator());
        paths.forEach(key -> complete.setProperty(key, valuesWithKey.get(key)));
        this.addProperties((HierarchicalConfiguration)cfg, (HierarchicalConfiguration)complete);
        return complete;
    }

    public XMLConfiguration getXmlConfiguration(String file, List<YangElement> elements) {
        InputStream stream = this.getCfgInputStream(file);
        XMLConfiguration cfg = this.loadXml(stream);
        XMLConfiguration complete = new XMLConfiguration();
        ArrayListMultimap commonElements = ArrayListMultimap.create();
        elements.forEach(arg_0 -> this.lambda$getXmlConfiguration$2((HierarchicalConfiguration)cfg, (Multimap)commonElements, arg_0));
        commonElements.keySet().forEach(arg_0 -> this.lambda$getXmlConfiguration$5((Multimap)commonElements, complete, arg_0));
        this.addProperties((HierarchicalConfiguration)cfg, (HierarchicalConfiguration)complete);
        return complete;
    }

    private void addProperties(HierarchicalConfiguration cfg, HierarchicalConfiguration complete) {
        cfg.getKeys().forEachRemaining(key -> {
            String property = (String)cfg.getProperty(key);
            if (!"".equals(property)) {
                complete.setProperty(key, (Object)property);
            }
        });
    }

    protected InputStream getCfgInputStream(String file) {
        return this.getClass().getResourceAsStream(file);
    }

    public List<YangElement> readXmlConfiguration(HierarchicalConfiguration cfg, String path) {
        ArrayList<YangElement> elements = new ArrayList<YangElement>();
        String key = (String)Tools.nullIsNotFound((Object)this.findPath(cfg, path), (String)"Configuration does not contain desired path");
        this.getElements(cfg.configurationsAt(key), elements, key, cfg, path, key);
        return ImmutableList.copyOf(elements);
    }

    private void getElements(List<HierarchicalConfiguration> configurations, List<YangElement> elements, String basekey, HierarchicalConfiguration originalCfg, String path, String originalKey) {
        configurations.forEach(config -> {
            YangElement element = new YangElement(path, new HashMap<String, String>());
            config.getKeys().forEachRemaining(key -> {
                if (key.split("\\.").length > 1) {
                    this.getElements(originalCfg.configurationsAt(basekey + "." + key.split("\\.")[0]), elements, basekey + "." + key.split("\\.")[0], originalCfg, path, originalKey);
                } else {
                    String replaced = basekey.replace(originalKey, "");
                    String partialKey = replaced.isEmpty() ? key : replaced.substring(1) + "." + key;
                    partialKey = partialKey.isEmpty() ? originalKey : partialKey;
                    element.getKeysAndValues().put(partialKey, config.getProperty(key).toString());
                }
            });
            if (!elements.contains(element) && !element.getKeysAndValues().isEmpty()) {
                elements.add(element);
            }
        });
    }

    public static YangXmlUtils getInstance() {
        if (instance == null) {
            instance = new YangXmlUtils();
        }
        return instance;
    }

    public String getString(XMLConfiguration cfg) {
        StringWriter stringWriter = new StringWriter();
        try {
            cfg.save((Writer)stringWriter);
        }
        catch (ConfigurationException e) {
            this.log.error("Cannot convert configuration", (Object)e.getMessage());
        }
        String xml = stringWriter.toString();
        xml = xml.substring(xml.indexOf("\n"));
        xml = xml.substring(xml.indexOf(">") + 1);
        return xml;
    }

    public XMLConfiguration loadXml(InputStream xmlStream) {
        XMLConfiguration cfg = new XMLConfiguration();
        try {
            cfg.load(xmlStream);
            return cfg;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Cannot load xml from Stream", e);
        }
    }

    private List<String> findPaths(HierarchicalConfiguration cfg, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        cfg.getKeys().forEachRemaining(key -> {
            if (key.equals(path)) {
                paths.add((String)key);
            }
            if (key.contains("." + path)) {
                paths.add((String)key);
            }
        });
        return paths;
    }

    private String findPath(HierarchicalConfiguration cfg, String element) {
        Iterator it = cfg.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] arr = key.split("\\.");
            for (int i = 0; i < arr.length; ++i) {
                if (!element.equals(arr[i])) continue;
                String completeKey = "";
                for (int j = 0; j <= i; ++j) {
                    completeKey = completeKey + "." + arr[j];
                }
                return completeKey.substring(1);
            }
        }
        return null;
    }

    private HierarchicalConfiguration getInnerNode(YangElement element) {
        HierarchicalConfiguration node = new HierarchicalConfiguration();
        node.setRoot(new HierarchicalConfiguration.Node(element.getBaseKey()));
        element.getKeysAndValues().forEach((arg_0, arg_1) -> ((HierarchicalConfiguration)node).setProperty(arg_0, arg_1));
        return node;
    }

    private /* synthetic */ void lambda$getXmlConfiguration$5(Multimap commonElements, XMLConfiguration complete, String key) {
        if (commonElements.get((Object)key).size() > 1) {
            ArrayList nodes = new ArrayList();
            commonElements.get((Object)key).forEach(element -> nodes.add(this.getInnerNode((YangElement)element).getRootNode()));
            String parentPath = key.substring(0, key.lastIndexOf("."));
            complete.addNodes(parentPath, nodes);
        } else {
            Map<String, String> keysAndValues = ((YangElement)commonElements.get((Object)key).stream().findFirst().get()).getKeysAndValues();
            keysAndValues.forEach((k, v) -> complete.setProperty(key + "." + k, v));
        }
    }

    private /* synthetic */ void lambda$getXmlConfiguration$2(HierarchicalConfiguration cfg, Multimap commonElements, YangElement element) {
        String completeKey = (String)Tools.nullIsNotFound((Object)this.findPath(cfg, element.getBaseKey()), (String)"Yang model does not contain desired path");
        commonElements.put((Object)completeKey, (Object)element);
    }

    private class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o2 == null && o1 == null) {
                return 0;
            }
            if (o1 == null) {
                return o2.length();
            }
            if (o2 == null) {
                return o1.length();
            }
            if (o1.length() != o2.length()) {
                return o1.length() - o2.length();
            }
            return o1.compareTo(o2);
        }
    }
}

