/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.onlab.packet.IpAddress;
import org.onosproject.net.behaviour.ControllerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlConfigParser {
    public static final Logger log = LoggerFactory.getLogger(XmlConfigParser.class);

    private XmlConfigParser() {
    }

    public static HierarchicalConfiguration loadXml(InputStream xmlStream) {
        XMLConfiguration cfg = new XMLConfiguration();
        try {
            cfg.load(xmlStream);
            return cfg;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Cannot load xml from Stream", e);
        }
    }

    public static HierarchicalConfiguration loadXmlString(String xmlStr) {
        return XmlConfigParser.loadXml(new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8)));
    }

    public static List<ControllerInfo> parseStreamControllers(HierarchicalConfiguration cfg) {
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        List fields = cfg.configurationsAt("data.capable-switch.logical-switches.switch.controllers.controller");
        for (HierarchicalConfiguration sub : fields) {
            controllers.add(new ControllerInfo(IpAddress.valueOf((String)sub.getString("ip-address")), Integer.parseInt(sub.getString("port")), sub.getString("protocol")));
        }
        return controllers;
    }

    protected static String parseSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch.logical-switches.switch");
        return field.getProperty("id").toString();
    }

    public static String parseCapableSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch");
        return field.getProperty("id").toString();
    }

    public static String createControllersConfig(HierarchicalConfiguration cfg, HierarchicalConfiguration actualCfg, String target, String netconfOperation, String controllerOperation, List<ControllerInfo> controllers) {
        cfg.setProperty("edit-config.target", (Object)target);
        cfg.setProperty("edit-config.default-operation", (Object)netconfOperation);
        cfg.setProperty("edit-config.config.capable-switch.id", (Object)XmlConfigParser.parseCapableSwitchId(actualCfg));
        cfg.setProperty("edit-config.config.capable-switch.logical-switches.switch.id", (Object)XmlConfigParser.parseSwitchId(actualCfg));
        ArrayList<ConfigurationNode> newControllers = new ArrayList<ConfigurationNode>();
        for (ControllerInfo ci : controllers) {
            XMLConfiguration controller = new XMLConfiguration();
            controller.setRoot(new HierarchicalConfiguration.Node("controller"));
            String id = ci.type() + ":" + ci.ip() + ":" + ci.port();
            controller.setProperty("id", (Object)id);
            controller.setProperty("ip-address", (Object)ci.ip());
            controller.setProperty("port", (Object)ci.port());
            controller.setProperty("protocol", (Object)ci.type());
            newControllers.add(controller.getRootNode());
        }
        cfg.addNodes("edit-config.config.capable-switch.logical-switches.switch.controllers", newControllers);
        XMLConfiguration editcfg = (XMLConfiguration)cfg;
        StringWriter stringWriter = new StringWriter();
        try {
            editcfg.save((Writer)stringWriter);
        }
        catch (ConfigurationException e) {
            log.error("createControllersConfig()", (Throwable)e);
        }
        String s = stringWriter.toString().replaceAll("<controller>", "<controller nc:operation=\"" + controllerOperation + "\">");
        s = s.replace("<target>" + target + "</target>", "<target><" + target + "/></target>");
        return s;
    }

    public static boolean configSuccess(HierarchicalConfiguration reply) {
        return reply != null && reply.containsKey("ok");
    }
}

