/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.DefaultQueueDescription;
import org.onosproject.net.behaviour.QueueConfigBehaviour;
import org.onosproject.net.behaviour.QueueDescription;
import org.onosproject.net.behaviour.QueueId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbQueueConfig
extends AbstractHandlerBehaviour
implements QueueConfigBehaviour {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Collection<QueueDescription> getQueues() {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return Collections.emptyList();
        }
        Set queues = ovsdbClient.getQueues();
        return queues.stream().map(q -> DefaultQueueDescription.builder().queueId(QueueId.queueId((String)((String)q.externalIds().get("onos-queue-id")))).type(this.types((OvsdbQueue)q)).dscp(q.dscp().isPresent() ? Integer.valueOf(((Long)q.dscp().get()).intValue()) : null).maxRate(q.otherConfigs().get("max-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)q.otherConfigs().get("max-rate"))) : Bandwidth.bps((long)0L)).minRate(q.otherConfigs().get("min-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)q.otherConfigs().get("min-rate"))) : Bandwidth.bps((long)0L)).burst(Long.valueOf(q.otherConfigs().get("burst") != null ? Long.valueOf((String)q.otherConfigs().get("burst")) : 0L)).priority(Long.valueOf(q.otherConfigs().get("priority") != null ? Long.valueOf((String)q.otherConfigs().get("priority")) : 0L)).build()).collect(Collectors.toSet());
    }

    public QueueDescription getQueue(QueueDescription queueDesc) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return null;
        }
        OvsdbQueue queue = ovsdbClient.getQueue(queueDesc.queueId());
        if (queue == null) {
            return null;
        }
        return DefaultQueueDescription.builder().queueId(QueueId.queueId((String)((String)queue.externalIds().get("onos-queue-id")))).type(this.types(queue)).dscp(queue.dscp().isPresent() ? Integer.valueOf(((Long)queue.dscp().get()).intValue()) : null).maxRate(queue.otherConfigs().get("max-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)queue.otherConfigs().get("max-rate"))) : Bandwidth.bps((long)0L)).minRate(queue.otherConfigs().get("min-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)queue.otherConfigs().get("min-rate"))) : Bandwidth.bps((long)0L)).burst(Long.valueOf(queue.otherConfigs().get("burst") != null ? Long.valueOf((String)queue.otherConfigs().get("burst")) : 0L)).priority(Long.valueOf(queue.otherConfigs().get("priority") != null ? Long.valueOf((String)queue.otherConfigs().get("priority")) : 0L)).build();
    }

    public boolean addQueue(QueueDescription queue) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        OvsdbQueue ovsdbQueue = OvsdbQueue.builder((QueueDescription)queue).build();
        return ovsdbClient.createQueue(ovsdbQueue);
    }

    public void deleteQueue(QueueId queueId) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        ovsdbClient.dropQueue(queueId);
    }

    private EnumSet<QueueDescription.Type> types(OvsdbQueue queue) {
        EnumSet<QueueDescription.Type> enumSet = EnumSet.noneOf(QueueDescription.Type.class);
        if (queue == null) {
            return enumSet;
        }
        if (queue.otherConfigs().get("max-rate") != null) {
            enumSet.add(QueueDescription.Type.MAX);
        }
        if (queue.otherConfigs().get("min-rate") != null) {
            enumSet.add(QueueDescription.Type.MIN);
        }
        if (queue.otherConfigs().get("burst") != null) {
            enumSet.add(QueueDescription.Type.BURST);
        }
        if (queue.otherConfigs().get("priority") != null) {
            enumSet.add(QueueDescription.Type.PRIORITY);
        }
        return enumSet;
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }

    private OvsdbClientService getOvsdbClient(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(handler.data().deviceId());
        return ovsController.getOvsdbClient(nodeId);
    }
}

