/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.DefaultQosDescription;
import org.onosproject.net.behaviour.QosConfigBehaviour;
import org.onosproject.net.behaviour.QosDescription;
import org.onosproject.net.behaviour.QosId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbQosConfig
extends AbstractHandlerBehaviour
implements QosConfigBehaviour {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Collection<QosDescription> getQoses() {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return null;
        }
        Set qoses = ovsdbClient.getQoses();
        return qoses.stream().map(qos -> DefaultQosDescription.builder().qosId(QosId.qosId((String)((String)qos.externalIds().get("onos-qos-id")))).type("egress-policer".equals(qos.qosType()) ? QosDescription.Type.EGRESS_POLICER : QosDescription.Type.valueOf((String)qos.qosType().replace("linux-", "").toUpperCase())).maxRate(qos.otherConfigs().get("max-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)qos.otherConfigs().get("max-rate"))) : Bandwidth.bps((long)0L)).cbs(qos.otherConfigs().get("cbs") != null ? Long.valueOf((String)qos.otherConfigs().get("cbs")) : null).cir(qos.otherConfigs().get("cir") != null ? Long.valueOf((String)qos.otherConfigs().get("cir")) : null).build()).collect(Collectors.toSet());
    }

    public QosDescription getQos(QosDescription qosDesc) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return null;
        }
        OvsdbQos qos = ovsdbClient.getQos(qosDesc.qosId());
        if (qos == null) {
            return null;
        }
        return DefaultQosDescription.builder().qosId(QosId.qosId((String)((String)qos.externalIds().get("onos-qos-id")))).type("egress-policer".equals(qos.qosType()) ? QosDescription.Type.EGRESS_POLICER : QosDescription.Type.valueOf((String)qos.qosType().replace("linux-", "").toUpperCase())).maxRate(qos.otherConfigs().get("max-rate") != null ? Bandwidth.bps((long)Long.parseLong((String)qos.otherConfigs().get("max-rate"))) : Bandwidth.bps((long)0L)).cbs(qos.otherConfigs().get("cbs") != null ? Long.valueOf((String)qos.otherConfigs().get("cbs")) : null).cir(qos.otherConfigs().get("cir") != null ? Long.valueOf((String)qos.otherConfigs().get("cir")) : null).build();
    }

    public boolean addQoS(QosDescription qos) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        OvsdbQos ovsdbQos = OvsdbQos.builder((QosDescription)qos).build();
        return ovsdbClient.createQos(ovsdbQos);
    }

    public void deleteQoS(QosId qosId) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        ovsdbClient.dropQos(qosId);
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }

    private OvsdbClientService getOvsdbClient(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(handler.data().deviceId());
        return ovsController.getOvsdbClient(nodeId);
    }
}

