/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.PortConfigBehaviour;
import org.onosproject.net.behaviour.QosDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbPortConfig
extends AbstractHandlerBehaviour
implements PortConfigBehaviour {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void applyQoS(PortDescription portDesc, QosDescription qosDesc) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return;
        }
        ovsdbClient.applyQos(portDesc.portNumber(), qosDesc.qosId().name());
    }

    public void removeQoS(PortNumber portNumber) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (ovsdbClient == null) {
            return;
        }
        ovsdbClient.removeQos(portNumber);
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }

    private OvsdbClientService getOvsdbClient(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(handler.data().deviceId());
        return ovsController.getOvsdbClient(nodeId);
    }
}

