/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.BridgeName;
import org.onosproject.net.behaviour.MirroringConfig;
import org.onosproject.net.behaviour.MirroringDescription;
import org.onosproject.net.behaviour.MirroringName;
import org.onosproject.net.behaviour.MirroringStatistics;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbBridge;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbMirror;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbMirroringConfig
extends AbstractHandlerBehaviour
implements MirroringConfig {
    private static Logger log = LoggerFactory.getLogger(OvsdbMirroringConfig.class);

    public boolean addMirroring(BridgeName bridge, MirroringDescription mirroringDescription) {
        DriverHandler handler = this.handler();
        OvsdbClientService ovsdbClient = this.getOvsdbClientService(handler);
        OvsdbMirror mirror = OvsdbMirror.builder((MirroringDescription)mirroringDescription).build();
        return ovsdbClient.createMirror(bridge.name(), mirror);
    }

    public void deleteMirroring(MirroringName mirroringName) {
        DriverHandler handler = this.handler();
        OvsdbClientService ovsdbClient = this.getOvsdbClientService(handler);
        ovsdbClient.dropMirror(mirroringName);
    }

    public Collection<MirroringStatistics> getMirroringStatistics() {
        DriverHandler handler = this.handler();
        OvsdbClientService ovsdbClient = this.getOvsdbClientService(handler);
        return ovsdbClient.getMirroringStatistics(handler.data().deviceId());
    }

    private OvsdbClientService getOvsdbClientService(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        DeviceService deviceService = (DeviceService)handler.get(DeviceService.class);
        DeviceId deviceId = handler.data().deviceId();
        String[] splits = deviceId.toString().split(":");
        if (splits == null || splits.length < 1) {
            log.warn("Wrong deviceId format");
            return null;
        }
        switch (splits[0]) {
            case "ovsdb": {
                OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(deviceId);
                return ovsController.getOvsdbClient(nodeId);
            }
            case "of": {
                List nodeIds;
                String[] mgmtAddress = deviceService.getDevice(deviceId).annotations().value("managementAddress").split(":");
                String targetIp = mgmtAddress[0];
                TpPort targetPort = null;
                if (mgmtAddress.length > 1) {
                    targetPort = TpPort.tpPort((int)Integer.parseInt(mgmtAddress[1]));
                }
                if ((nodeIds = ovsController.getNodeIds().stream().filter(nodeID -> nodeID.getIpAddress().equals(targetIp)).collect(Collectors.toList())).isEmpty()) {
                    ovsController.connect(IpAddress.valueOf((String)targetIp), targetPort == null ? TpPort.tpPort((int)6640) : targetPort);
                    Tools.delay((int)1000);
                }
                List clientServices = ovsController.getNodeIds().stream().filter(nodeID -> nodeID.getIpAddress().equals(targetIp)).map(arg_0 -> ((OvsdbController)ovsController).getOvsdbClient(arg_0)).filter(cs -> cs.getBridges().stream().anyMatch(b -> OvsdbMirroringConfig.dpidMatches(b, deviceId))).collect(Collectors.toList());
                Preconditions.checkState((!clientServices.isEmpty() ? 1 : 0) != 0, (Object)"No clientServices found");
                return !clientServices.isEmpty() ? (OvsdbClientService)clientServices.get(0) : null;
            }
        }
        log.warn("Unmanaged device type");
        return null;
    }

    private static boolean dpidMatches(OvsdbBridge bridge, DeviceId deviceId) {
        Preconditions.checkArgument((boolean)bridge.datapathId().isPresent());
        String bridgeDpid = "of:" + (String)bridge.datapathId().get();
        String ofDpid = deviceId.toString();
        return bridgeDpid.equals(ofDpid);
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits == null || splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }
}

