/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import java.util.List;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.behaviour.PatchDescription;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.device.DeviceInterfaceDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbInterface;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbInterfaceConfig
extends AbstractHandlerBehaviour
implements InterfaceConfig {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean addTunnelMode(String ifaceName, TunnelDescription tunnelDesc) {
        OvsdbInterface ovsdbIface = OvsdbInterface.builder((TunnelDescription)tunnelDesc).build();
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (!tunnelDesc.deviceId().isPresent()) {
            this.log.warn("Device ID is required {}", (Object)tunnelDesc);
            return false;
        }
        return ovsdbClient.createInterface((String)tunnelDesc.deviceId().get(), ovsdbIface);
    }

    public boolean removeTunnelMode(String ifaceName) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        return ovsdbClient.dropInterface(ifaceName);
    }

    public boolean addAccessMode(String ifaceName, VlanId vlanId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean removeAccessMode(String ifaceName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean addPatchMode(String ifaceName, PatchDescription patchDesc) {
        OvsdbInterface ovsdbIface = OvsdbInterface.builder((PatchDescription)patchDesc).build();
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        if (!patchDesc.deviceId().isPresent()) {
            this.log.warn("Device ID is required {}", (Object)patchDesc);
            return false;
        }
        return ovsdbClient.createInterface((String)patchDesc.deviceId().get(), ovsdbIface);
    }

    public boolean removePatchMode(String ifaceName) {
        OvsdbClientService ovsdbClient = this.getOvsdbClient(this.handler());
        return ovsdbClient.dropInterface(ifaceName);
    }

    public boolean addTrunkMode(String ifaceName, List<VlanId> vlanIds) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean removeTrunkMode(String ifaceName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean addRateLimit(String ifaceName, short limit) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean removeRateLimit(String ifaceName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<DeviceInterfaceDescription> getInterfaces() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean addAccessInterface(DeviceId deviceId, String ifaceName, VlanId vlanId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean removeAccessInterface(DeviceId deviceId, String ifaceName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean addTrunkInterface(DeviceId deviceId, String ifaceName, List<VlanId> vlanIds) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<DeviceInterfaceDescription> getInterfaces(DeviceId deviceId) {
        return null;
    }

    public boolean removeTrunkInterface(DeviceId deviceId, String ifaceName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }

    private OvsdbClientService getOvsdbClient(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(handler.data().deviceId());
        return ovsController.getOvsdbClient(nodeId);
    }
}

