/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ControllerConfig;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbBridge;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;

public class OvsdbControllerConfig
extends AbstractHandlerBehaviour
implements ControllerConfig {
    public List<ControllerInfo> getControllers() {
        DriverHandler handler = this.handler();
        OvsdbClientService clientService = this.getOvsdbClientService(handler);
        Set controllers = clientService.getControllers(this.handler().data().deviceId());
        return new ArrayList<ControllerInfo>(controllers);
    }

    public void setControllers(List<ControllerInfo> controllers) {
        DriverHandler handler = this.handler();
        OvsdbClientService clientService = this.getOvsdbClientService(handler);
        if (!clientService.getControllers(this.handler().data().deviceId()).equals(ImmutableSet.copyOf(controllers))) {
            clientService.setControllersWithDeviceId(this.handler().data().deviceId(), controllers);
        }
    }

    private OvsdbClientService getOvsdbClientService(DriverHandler handler) {
        List nodeIds;
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        DeviceService deviceService = (DeviceService)handler.get(DeviceService.class);
        DeviceId ofDeviceId = handler.data().deviceId();
        String[] mgmtAddress = deviceService.getDevice(ofDeviceId).annotations().value("managementAddress").split(":");
        String targetIp = mgmtAddress[0];
        TpPort targetPort = null;
        if (mgmtAddress.length > 1) {
            targetPort = TpPort.tpPort((int)Integer.parseInt(mgmtAddress[1]));
        }
        if ((nodeIds = ovsController.getNodeIds().stream().filter(nodeId -> nodeId.getIpAddress().equals(targetIp)).collect(Collectors.toList())).isEmpty()) {
            ovsController.connect(IpAddress.valueOf((String)targetIp), targetPort == null ? TpPort.tpPort((int)6640) : targetPort);
            Tools.delay((int)1000);
        }
        List clientServices = ovsController.getNodeIds().stream().filter(nodeId -> nodeId.getIpAddress().equals(targetIp)).map(arg_0 -> ((OvsdbController)ovsController).getOvsdbClient(arg_0)).filter(cs -> cs.getBridges().stream().anyMatch(b -> OvsdbControllerConfig.dpidMatches(b, ofDeviceId))).collect(Collectors.toList());
        Preconditions.checkState((!clientServices.isEmpty() ? 1 : 0) != 0, (Object)"No clientServices found");
        return !clientServices.isEmpty() ? (OvsdbClientService)clientServices.get(0) : null;
    }

    private static boolean dpidMatches(OvsdbBridge bridge, DeviceId deviceId) {
        Preconditions.checkArgument((boolean)bridge.datapathId().isPresent());
        String bridgeDpid = "of:" + (String)bridge.datapathId().get();
        String ofDpid = deviceId.toString();
        return bridgeDpid.equals(ofDpid);
    }
}

