/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ovsdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.BridgeName;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.behaviour.DefaultBridgeDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.ovsdb.controller.OvsdbBridge;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;

public class OvsdbBridgeConfig
extends AbstractHandlerBehaviour
implements BridgeConfig {
    @Deprecated
    public void addBridge(BridgeName bridgeName) {
        BridgeDescription bridgeDesc = DefaultBridgeDescription.builder().name(bridgeName.name()).build();
        this.addBridge(bridgeDesc);
    }

    @Deprecated
    public void addBridge(BridgeName bridgeName, String dpid, String exPortName) {
        BridgeDescription bridgeDesc = DefaultBridgeDescription.builder().name(bridgeName.name()).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().enableLocalController().build();
        this.addBridge(bridgeDesc);
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return;
        }
        client.createPort(bridgeName.name(), exPortName);
    }

    @Deprecated
    public boolean addBridge(BridgeName bridgeName, String dpid, List<ControllerInfo> controllers) {
        BridgeDescription bridgeDesc = DefaultBridgeDescription.builder().name(bridgeName.name()).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().controllers(controllers).build();
        return this.addBridge(bridgeDesc);
    }

    public boolean addBridge(BridgeDescription bridgeDesc) {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return false;
        }
        OvsdbBridge.Builder bridgeBuilder = OvsdbBridge.builder((BridgeDescription)bridgeDesc);
        if (bridgeDesc.enableLocalController()) {
            bridgeBuilder.controller(client.localController());
        }
        return client.createBridge(bridgeBuilder.build());
    }

    public void deleteBridge(BridgeName bridgeName) {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return;
        }
        client.dropBridge(bridgeName.name());
    }

    public Collection<BridgeDescription> getBridges() {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return Collections.emptyList();
        }
        Set bridges = client.getBridges();
        return bridges.stream().map(bridge -> DefaultBridgeDescription.builder().name(bridge.name()).datapathId((String)bridge.datapathId().get()).build()).collect(Collectors.toSet());
    }

    public void addPort(BridgeName bridgeName, String portName) {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return;
        }
        client.createPort(bridgeName.name(), portName);
    }

    public void deletePort(BridgeName bridgeName, String portName) {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return;
        }
        client.dropPort(bridgeName.name(), portName);
    }

    public Collection<PortDescription> getPorts() {
        OvsdbClientService client = this.getOvsdbClientService(this.handler());
        if (client == null) {
            return Collections.emptyList();
        }
        Set ports = client.getPorts();
        return ports.stream().map(x -> new DefaultPortDescription(PortNumber.portNumber((long)x.portNumber().value()), true, new SparseAnnotations[]{DefaultAnnotations.builder().set("portName", x.portName().value()).build()})).collect(Collectors.toSet());
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] splits = deviceId.toString().split(":");
        if (splits == null || splits.length < 1) {
            return null;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)splits[1]);
        return new OvsdbNodeId(ipAddress, 0L);
    }

    private OvsdbClientService getOvsdbClientService(DriverHandler handler) {
        OvsdbController ovsController = (OvsdbController)handler.get(OvsdbController.class);
        DeviceId deviceId = handler.data().deviceId();
        OvsdbNodeId nodeId = this.changeDeviceIdToNodeId(deviceId);
        return ovsController.getOvsdbClient(nodeId);
    }

    public Set<PortNumber> getPortNumbers() {
        DriverHandler handler = this.handler();
        OvsdbClientService client = this.getOvsdbClientService(handler);
        if (client == null) {
            return Collections.emptySet();
        }
        Set ports = client.getPorts();
        return ports.stream().map(x -> PortNumber.portNumber((long)x.portNumber().value(), (String)x.portName().value())).collect(Collectors.toSet());
    }

    public List<PortNumber> getLocalPorts(Iterable<String> ifaceIds) {
        ArrayList<PortNumber> ports = new ArrayList<PortNumber>();
        DriverHandler handler = this.handler();
        OvsdbClientService client = this.getOvsdbClientService(handler);
        if (client == null) {
            return Collections.emptyList();
        }
        Set ovsdbSet = client.getLocalPorts(ifaceIds);
        ovsdbSet.forEach(o -> {
            PortNumber port = PortNumber.portNumber((long)o.portNumber().value(), (String)o.portName().value());
            ports.add(port);
        });
        return ports;
    }
}

