/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.cli;

import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.net.DeviceId;

@Command(scope="onos", name="alarms-counts", description="Lists the count of alarms for each severity")
public class GetAllAlarmsCounts
extends AbstractShellCommand {
    @Option(name="-a", aliases={"--active"}, description="Shows ACTIVE alarms only", required=false, multiValued=false)
    private boolean activeOnly = false;
    @Argument(index=0, name="deviceId", description="Device identity", required=false, multiValued=false)
    String deviceId = null;
    private AlarmService alarmService = (AlarmService)AbstractShellCommand.get(AlarmService.class);
    private Map<Alarm.SeverityLevel, Long> alarmCounts;

    protected void execute() {
        this.alarmCounts = this.deviceId != null ? (this.activeOnly ? this.alarmService.getActiveAlarms(DeviceId.deviceId((String)this.deviceId)).stream().filter(a -> !a.severity().equals((Object)Alarm.SeverityLevel.CLEARED)).collect(Collectors.groupingBy(Alarm::severity, Collectors.counting())) : this.alarmService.getAlarmCounts(DeviceId.deviceId((String)this.deviceId))) : (this.activeOnly ? this.alarmService.getActiveAlarms().stream().filter(a -> !a.severity().equals((Object)Alarm.SeverityLevel.CLEARED)).collect(Collectors.groupingBy(Alarm::severity, Collectors.counting())) : this.alarmService.getAlarmCounts());
        this.printCounts(this.alarmCounts);
    }

    void printCounts(Map<Alarm.SeverityLevel, Long> alarmCounts) {
        alarmCounts.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Alarm.SeverityLevel)e.getKey()).ordinal())).forEach(countEntry -> this.print(String.format("%s, %d", countEntry.getKey(), countEntry.getValue()), new Object[0]));
    }
}

