/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.group.impl;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProvider;
import org.onosproject.net.group.GroupProviderRegistry;
import org.onosproject.net.group.GroupProviderService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.group.StoredGroupBucketEntry;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.group.impl.GroupBucketEntryBuilder;
import org.onosproject.provider.of.group.impl.GroupModBuilder;
import org.onosproject.provider.of.group.impl.GroupStatsCollector;
import org.projectfloodlight.openflow.protocol.OFBucketCounter;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFGroupAdd;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupModFailedCode;
import org.projectfloodlight.openflow.protocol.OFGroupStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFGroupModFailedErrorMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowGroupProvider
extends AbstractProvider
implements GroupProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    private GroupProviderService providerService;
    static final int POLL_INTERVAL = 10;
    private final InternalGroupProvider listener = new InternalGroupProvider();
    private static final AtomicLong XID_COUNTER = new AtomicLong(1L);
    private final Map<Dpid, GroupStatsCollector> collectors = Maps.newHashMap();
    private final Map<Long, OFStatsReply> groupStats = Maps.newConcurrentMap();
    private final Map<GroupId, GroupOperation> pendingGroupOperations = Maps.newConcurrentMap();
    private final Map<GroupId, Long> pendingXidMaps = Maps.newConcurrentMap();

    public OpenFlowGroupProvider() {
        super(new ProviderId("of", "org.onosproject.provider.group"));
    }

    @Activate
    public void activate() {
        this.providerService = (GroupProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addEventListener((OpenFlowEventListener)this.listener);
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            if (!this.isGroupSupported(sw)) continue;
            GroupStatsCollector gsc = new GroupStatsCollector(sw, 10);
            gsc.start();
            this.collectors.put(new Dpid(sw.getId()), gsc);
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.collectors.values().forEach(GroupStatsCollector::stop);
        this.collectors.clear();
        this.log.info("Stopped");
    }

    public void performGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        for (GroupOperation groupOperation : groupOps.operations()) {
            if (sw == null) {
                this.log.error("SW {} is not found", (Object)dpid);
                return;
            }
            Long groupModXid = XID_COUNTER.getAndIncrement();
            GroupModBuilder builder = null;
            builder = this.driverService == null ? GroupModBuilder.builder(groupOperation.buckets(), groupOperation.groupId(), groupOperation.groupType(), sw.factory(), Optional.of(groupModXid)) : GroupModBuilder.builder(groupOperation.buckets(), groupOperation.groupId(), groupOperation.groupType(), sw.factory(), Optional.of(groupModXid), Optional.of(this.driverService));
            OFGroupAdd groupMod = null;
            switch (groupOperation.opType()) {
                case ADD: {
                    groupMod = builder.buildGroupAdd();
                    break;
                }
                case MODIFY: {
                    groupMod = builder.buildGroupMod();
                    break;
                }
                case DELETE: {
                    groupMod = builder.buildGroupDel();
                    break;
                }
                default: {
                    this.log.error("Unsupported Group operation");
                    return;
                }
            }
            sw.sendMsg((OFMessage)groupMod);
            GroupId groudId = new GroupId(groupMod.getGroup().getGroupNumber());
            this.pendingGroupOperations.put(groudId, groupOperation);
            this.pendingXidMaps.put(groudId, groupModXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushGroupMetrics(Dpid dpid, OFStatsReply statsReply) {
        DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        OFGroupStatsReply groupStatsReply = null;
        OFGroupDescStatsReply groupDescStatsReply = null;
        Map<Long, OFStatsReply> map = this.groupStats;
        synchronized (map) {
            OFStatsReply reply;
            if (statsReply.getStatsType() == OFStatsType.GROUP) {
                reply = this.groupStats.get(statsReply.getXid() + 1L);
                if (reply != null) {
                    groupStatsReply = (OFGroupStatsReply)statsReply;
                    groupDescStatsReply = (OFGroupDescStatsReply)reply;
                    this.groupStats.remove(statsReply.getXid() + 1L);
                } else {
                    this.groupStats.put(statsReply.getXid(), statsReply);
                }
            } else if (statsReply.getStatsType() == OFStatsType.GROUP_DESC) {
                reply = this.groupStats.get(statsReply.getXid() - 1L);
                if (reply != null) {
                    groupStatsReply = (OFGroupStatsReply)reply;
                    groupDescStatsReply = (OFGroupDescStatsReply)statsReply;
                    this.groupStats.remove(statsReply.getXid() - 1L);
                } else {
                    this.groupStats.put(statsReply.getXid(), statsReply);
                }
            }
        }
        if (this.providerService != null && groupStatsReply != null) {
            Collection<Group> groups = this.buildGroupMetrics(deviceId, groupStatsReply, groupDescStatsReply);
            this.providerService.pushGroupMetrics(deviceId, groups);
            for (Group group : groups) {
                this.pendingGroupOperations.remove(group.id());
                this.pendingXidMaps.remove(group.id());
            }
        }
    }

    private Collection<Group> buildGroupMetrics(DeviceId deviceId, OFGroupStatsReply groupStatsReply, OFGroupDescStatsReply groupDescStatsReply) {
        HashMap groups = Maps.newHashMap();
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        for (OFGroupDescStatsEntry entry : groupDescStatsReply.getEntries()) {
            int id = entry.getGroup().getGroupNumber();
            GroupId groupId = new GroupId(id);
            GroupDescription.Type type = this.getGroupType(entry.getGroupType());
            GroupBuckets buckets = new GroupBucketEntryBuilder(dpid, entry.getBuckets(), entry.getGroupType(), this.driverService).build();
            DefaultGroup group = new DefaultGroup(groupId, deviceId, type, buckets);
            groups.put(id, group);
        }
        for (OFGroupDescStatsEntry entry : groupStatsReply.getEntries()) {
            int groupId = entry.getGroup().getGroupNumber();
            DefaultGroup group = (DefaultGroup)groups.get(groupId);
            if (group == null) continue;
            group.setBytes(entry.getByteCount().getValue());
            group.setLife(entry.getDurationSec());
            group.setPackets(entry.getPacketCount().getValue());
            group.setReferenceCount(entry.getRefCount());
            int bucketIndex = 0;
            for (OFBucketCounter bucketStats : entry.getBucketStats()) {
                ((StoredGroupBucketEntry)group.buckets().buckets().get(bucketIndex)).setPackets(bucketStats.getPacketCount().getValue());
                ((StoredGroupBucketEntry)group.buckets().buckets().get(bucketIndex)).setBytes(((OFBucketCounter)entry.getBucketStats().get(bucketIndex)).getByteCount().getValue());
                ++bucketIndex;
            }
        }
        return groups.values();
    }

    private GroupDescription.Type getGroupType(OFGroupType type) {
        switch (type) {
            case ALL: {
                return GroupDescription.Type.ALL;
            }
            case INDIRECT: {
                return GroupDescription.Type.INDIRECT;
            }
            case SELECT: {
                return GroupDescription.Type.SELECT;
            }
            case FF: {
                return GroupDescription.Type.FAILOVER;
            }
        }
        this.log.error("Unsupported OF group type : {}", (Object)type);
        return null;
    }

    public static long getXidAndAdd(int increase) {
        return XID_COUNTER.getAndAdd(increase);
    }

    private boolean isGroupSupported(OpenFlowSwitch sw) {
        return sw.factory().getVersion() != OFVersion.OF_10 && sw.factory().getVersion() != OFVersion.OF_11 && sw.factory().getVersion() != OFVersion.OF_12;
    }

    private List<Group> checkFailoverGroups(Dpid dpid, OFPortStatus status) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        OFPortDesc desc = status.getDesc();
        PortNumber portNumber = PortNumber.portNumber((long)desc.getPortNo().getPortNumber());
        DeviceId id = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        if (desc.isEnabled()) {
            return groupList;
        }
        for (Group group : this.groupService.getGroups(id)) {
            if (group.type() != GroupDescription.Type.FAILOVER || !this.checkFailoverGroup(group, id, portNumber)) continue;
            groupList.add(group);
        }
        return groupList;
    }

    private boolean checkFailoverGroup(Group group, DeviceId id, PortNumber portNumber) {
        boolean portReached = false;
        boolean portEnabled = false;
        Iterator bIterator = group.buckets().buckets().iterator();
        while (bIterator.hasNext() && !portReached) {
            GroupBucket bucket = (GroupBucket)bIterator.next();
            if (this.deviceService.getPort(id, bucket.watchPort()).isEnabled()) {
                portEnabled = true;
            }
            if (!bucket.watchPort().equals((Object)portNumber)) continue;
            portReached = true;
        }
        return portReached && !portEnabled;
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindProviderRegistry(GroupProviderRegistry groupProviderRegistry) {
        this.providerRegistry = groupProviderRegistry;
    }

    protected void unbindProviderRegistry(GroupProviderRegistry groupProviderRegistry) {
        if (this.providerRegistry == groupProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    private class InternalGroupProvider
    implements OpenFlowSwitchListener,
    OpenFlowEventListener {
        private InternalGroupProvider() {
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            switch (msg.getType()) {
                case STATS_REPLY: {
                    OpenFlowGroupProvider.this.pushGroupMetrics(dpid, (OFStatsReply)msg);
                    break;
                }
                case ERROR: {
                    OFErrorMsg errorMsg = (OFErrorMsg)msg;
                    if (errorMsg.getErrType() != OFErrorType.GROUP_MOD_FAILED) break;
                    GroupId pendingGroupId = null;
                    for (Map.Entry entry : OpenFlowGroupProvider.this.pendingXidMaps.entrySet()) {
                        if (((Long)entry.getValue()).longValue() != errorMsg.getXid()) continue;
                        pendingGroupId = (GroupId)entry.getKey();
                        break;
                    }
                    if (pendingGroupId == null) {
                        OpenFlowGroupProvider.this.log.warn("Error for unknown group operation: {}", (Object)errorMsg.getXid());
                        break;
                    }
                    GroupOperation operation = (GroupOperation)OpenFlowGroupProvider.this.pendingGroupOperations.get(pendingGroupId);
                    DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
                    if (operation != null) {
                        OFGroupModFailedCode code = ((OFGroupModFailedErrorMsg)errorMsg).getCode();
                        GroupOperation.GroupMsgErrorCode failureCode = GroupOperation.GroupMsgErrorCode.values()[code.ordinal()];
                        GroupOperation failedOperation = GroupOperation.createFailedGroupOperation((GroupOperation)operation, (GroupOperation.GroupMsgErrorCode)failureCode);
                        OpenFlowGroupProvider.this.log.warn("Received a group mod error {}", (Object)msg);
                        OpenFlowGroupProvider.this.providerService.groupOperationFailed(deviceId, failedOperation);
                        OpenFlowGroupProvider.this.pendingGroupOperations.remove(pendingGroupId);
                        OpenFlowGroupProvider.this.pendingXidMaps.remove(pendingGroupId);
                        break;
                    }
                    OpenFlowGroupProvider.this.log.error("Cannot find pending group operation with group ID: {}", (Object)pendingGroupId);
                    break;
                }
            }
        }

        public void switchAdded(Dpid dpid) {
            OpenFlowSwitch sw = OpenFlowGroupProvider.this.controller.getSwitch(dpid);
            if (sw == null) {
                return;
            }
            if (OpenFlowGroupProvider.this.isGroupSupported(sw)) {
                GroupStatsCollector gsc = new GroupStatsCollector(sw, 10);
                gsc.start();
                this.stopCollectorIfNeeded(OpenFlowGroupProvider.this.collectors.put(dpid, gsc));
            }
            if (OpenFlowGroupProvider.this.controller.getSwitch(dpid) == null) {
                this.switchRemoved(dpid);
            }
        }

        public void switchRemoved(Dpid dpid) {
            this.stopCollectorIfNeeded((GroupStatsCollector)OpenFlowGroupProvider.this.collectors.remove(dpid));
        }

        private void stopCollectorIfNeeded(GroupStatsCollector collector) {
            if (collector != null) {
                collector.stop();
            }
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
            OpenFlowGroupProvider.this.providerService.notifyOfFailovers((Collection)OpenFlowGroupProvider.this.checkFailoverGroups(dpid, status));
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

