/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.group.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.provider.of.flow.util.FlowEntryBuilder;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupBucketEntryBuilder {
    private Dpid dpid;
    private List<OFBucket> ofBuckets;
    private OFGroupType type;
    private DriverService driverService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public GroupBucketEntryBuilder(Dpid dpid, List<OFBucket> ofBuckets, OFGroupType type, DriverService driverService) {
        this.dpid = dpid;
        this.ofBuckets = ofBuckets;
        this.type = type;
        this.driverService = driverService;
    }

    public GroupBuckets build() {
        ArrayList bucketList = Lists.newArrayList();
        for (OFBucket bucket : this.ofBuckets) {
            TrafficTreatment treatment = this.buildTreatment(bucket.getActions());
            GroupBucket groupBucket = null;
            switch (this.type) {
                case INDIRECT: {
                    groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment);
                    break;
                }
                case SELECT: {
                    groupBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)treatment, (short)((short)bucket.getWeight()));
                    break;
                }
                case FF: {
                    PortNumber port = PortNumber.portNumber((long)bucket.getWatchPort().getPortNumber());
                    GroupId groupId = new GroupId(bucket.getWatchGroup().getGroupNumber());
                    groupBucket = DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)treatment, (PortNumber)port, (GroupId)groupId);
                    break;
                }
                case ALL: {
                    groupBucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatment);
                    break;
                }
                default: {
                    this.log.error("Unsupported Group type : {}", (Object)this.type);
                }
            }
            if (groupBucket == null) continue;
            bucketList.add(groupBucket);
        }
        return new GroupBuckets((List)bucketList);
    }

    private TrafficTreatment buildTreatment(List<OFAction> actions) {
        DriverHandler driverHandler = this.getDriver(this.dpid);
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        if (actions.isEmpty()) {
            builder.drop();
            return builder.build();
        }
        return FlowEntryBuilder.configureTreatmentBuilder(actions, (TrafficTreatment.Builder)builder, (DriverHandler)driverHandler, (DeviceId)DeviceId.deviceId((URI)Dpid.uri((Dpid)this.dpid))).build();
    }

    private DriverHandler getDriver(Dpid dpid) {
        DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        Driver driver = this.driverService.getDriver(deviceId);
        DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, deviceId));
        return handler;
    }
}

