/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcprelay;

import org.onlab.packet.Ip4Address;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class DhcpRelayConfig
extends Config<ApplicationId> {
    private static final String DHCP_CONNECT_POINT = "dhcpserverConnectPoint";
    private static final String DHCP_SERVER_IP = "serverip";
    private static final String DHCP_GATEWAY_IP = "gatewayip";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{DHCP_CONNECT_POINT, DHCP_SERVER_IP, DHCP_GATEWAY_IP}) && this.isConnectPoint(DHCP_CONNECT_POINT, Config.FieldPresence.MANDATORY) && this.isIpAddress(DHCP_SERVER_IP, Config.FieldPresence.MANDATORY) && this.isIpAddress(DHCP_GATEWAY_IP, Config.FieldPresence.OPTIONAL);
    }

    public ConnectPoint getDhcpServerConnectPoint() {
        return ConnectPoint.deviceConnectPoint((String)this.object.path(DHCP_CONNECT_POINT).asText());
    }

    public Ip4Address getDhcpServerIp() {
        String ip = this.get(DHCP_SERVER_IP, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public Ip4Address getDhcpGatewayIp() {
        String gip = this.get(DHCP_GATEWAY_IP, null);
        return gip != null ? Ip4Address.valueOf((String)gip) : null;
    }
}

