/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcprelay;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.dhcprelay.DhcpRelayConfig;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DhcpRelay {
    public static final String DHCP_RELAY_APP = "org.onosproject.dhcp-relay";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    private static MacAddress myMAC = MacAddress.valueOf((String)"4f:4f:4f:4f:4f:4f");
    private final Set<ConfigFactory> factories = ImmutableSet.of((Object)new ConfigFactory<ApplicationId, DhcpRelayConfig>(SubjectFactories.APP_SUBJECT_FACTORY, DhcpRelayConfig.class, "dhcprelay"){

        public DhcpRelayConfig createConfig() {
            return new DhcpRelayConfig();
        }
    });
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Property(name="arpEnabled", boolValue={true}, label="Enable Address resolution protocol")
    protected boolean arpEnabled = true;
    private DhcpRelayPacketProcessor dhcpRelayPacketProcessor = new DhcpRelayPacketProcessor();
    private InternalHostListener hostListener = new InternalHostListener();
    private Ip4Address dhcpServerIp = null;
    private ConnectPoint dhcpServerConnectPoint = null;
    private MacAddress dhcpConnectMac = null;
    private VlanId dhcpConnectVlan = null;
    private Ip4Address dhcpGatewayIp = null;
    private ApplicationId appId;

    @Activate
    protected void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication(DHCP_RELAY_APP);
        this.cfgService.addListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        this.updateConfig();
        this.packetService.addProcessor((PacketProcessor)this.dhcpRelayPacketProcessor, PacketProcessor.director((int)0));
        this.hostService.addListener((EventListener)this.hostListener);
        this.requestDhcpPackets();
        this.modified(context);
        this.log.info("DHCP-RELAY Started");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.packetService.removeProcessor((PacketProcessor)this.dhcpRelayPacketProcessor);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.cancelDhcpPackets();
        this.cancelArpPackets();
        if (this.dhcpGatewayIp != null) {
            this.hostService.stopMonitoringIp((IpAddress)this.dhcpGatewayIp);
        } else {
            this.hostService.stopMonitoringIp((IpAddress)this.dhcpServerIp);
        }
        this.log.info("DHCP-RELAY Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"arpEnabled");
        if (flag != null) {
            this.arpEnabled = flag;
            this.log.info("Address resolution protocol is {}", (Object)(this.arpEnabled ? "enabled" : "disabled"));
        }
        if (this.arpEnabled) {
            this.requestArpPackets();
        } else {
            this.cancelArpPackets();
        }
    }

    private boolean configured() {
        return this.dhcpServerConnectPoint != null && this.dhcpServerIp != null;
    }

    private void updateConfig() {
        DhcpRelayConfig cfg = (DhcpRelayConfig)this.cfgService.getConfig((Object)this.appId, DhcpRelayConfig.class);
        if (cfg == null) {
            this.log.warn("Dhcp Server info not available");
            return;
        }
        this.dhcpServerConnectPoint = cfg.getDhcpServerConnectPoint();
        Ip4Address oldDhcpServerIp = this.dhcpServerIp;
        Ip4Address oldDhcpGatewayIp = this.dhcpGatewayIp;
        this.dhcpServerIp = cfg.getDhcpServerIp();
        this.dhcpGatewayIp = cfg.getDhcpGatewayIp();
        this.dhcpConnectMac = null;
        this.dhcpConnectVlan = null;
        this.log.info("dhcp server connect point: " + this.dhcpServerConnectPoint);
        this.log.info("dhcp server ipaddress " + this.dhcpServerIp);
        if (this.dhcpGatewayIp != null) {
            Set ghosts = this.hostService.getHostsByIp((IpAddress)this.dhcpGatewayIp);
            if (ghosts == null || ghosts.isEmpty()) {
                this.log.info("Probing to resolve dhcp gateway IP {}", (Object)this.dhcpGatewayIp);
                if (oldDhcpGatewayIp != null) {
                    this.hostService.stopMonitoringIp((IpAddress)oldDhcpGatewayIp);
                }
                this.hostService.startMonitoringIp((IpAddress)this.dhcpGatewayIp);
            } else {
                this.hostUpdated((Host)ghosts.iterator().next());
            }
        } else {
            Set shosts = this.hostService.getHostsByIp((IpAddress)this.dhcpServerIp);
            if (shosts == null || shosts.isEmpty()) {
                this.log.info("Probing to resolve dhcp server IP {}", (Object)this.dhcpServerIp);
                if (oldDhcpServerIp != null) {
                    this.hostService.stopMonitoringIp((IpAddress)oldDhcpServerIp);
                }
                this.hostService.startMonitoringIp((IpAddress)this.dhcpServerIp);
            } else {
                this.hostUpdated((Host)shosts.iterator().next());
            }
        }
    }

    private void hostRemoved(Host host) {
        if (host.ipAddresses().contains(this.dhcpServerIp)) {
            this.log.warn("DHCP server {} removed", (Object)this.dhcpServerIp);
            this.dhcpConnectMac = null;
            this.dhcpConnectVlan = null;
        }
        if (this.dhcpGatewayIp != null && host.ipAddresses().contains(this.dhcpGatewayIp)) {
            this.log.warn("DHCP gateway {} removed", (Object)this.dhcpGatewayIp);
            this.dhcpConnectMac = null;
            this.dhcpConnectVlan = null;
        }
    }

    private void hostUpdated(Host host) {
        if (this.dhcpGatewayIp != null) {
            if (host.ipAddresses().contains(this.dhcpGatewayIp)) {
                this.dhcpConnectMac = host.mac();
                this.dhcpConnectVlan = host.vlan();
                this.log.info("DHCP gateway {} resolved to Mac/Vlan:{}/{}", new Object[]{this.dhcpGatewayIp, this.dhcpConnectMac, this.dhcpConnectVlan});
            }
            return;
        }
        if (host.ipAddresses().contains(this.dhcpServerIp)) {
            this.dhcpConnectMac = host.mac();
            this.dhcpConnectVlan = host.vlan();
            this.log.info("DHCP server {} resolved to Mac/Vlan:{}/{}", new Object[]{this.dhcpServerIp, this.dhcpConnectMac, this.dhcpConnectVlan});
        }
    }

    private void requestDhcpPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)67));
        this.packetService.requestPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorClient = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.requestPackets(selectorClient.build(), PacketPriority.CONTROL, this.appId);
    }

    private void cancelDhcpPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)67));
        this.packetService.cancelPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector.Builder selectorClient = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.cancelPackets(selectorClient.build(), PacketPriority.CONTROL, this.appId);
    }

    private void requestArpPackets() {
        TrafficSelector.Builder selectorArpServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selectorArpServer.build(), PacketPriority.CONTROL, this.appId);
    }

    private void cancelArpPackets() {
        TrafficSelector.Builder selectorArpServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selectorArpServer.build(), PacketPriority.CONTROL, this.appId);
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_UPDATED: {
                    DhcpRelay.this.hostUpdated((Host)event.subject());
                    break;
                }
                case HOST_REMOVED: {
                    DhcpRelay.this.hostRemoved((Host)event.subject());
                    break;
                }
                case HOST_MOVED: {
                    break;
                }
            }
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if ((event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(DhcpRelayConfig.class)) {
                DhcpRelay.this.updateConfig();
                DhcpRelay.this.log.info("Reconfigured");
            }
        }
    }

    private class DhcpRelayPacketProcessor
    implements PacketProcessor {
        private DhcpRelayPacketProcessor() {
        }

        public void process(PacketContext context) {
            if (!DhcpRelay.this.configured()) {
                DhcpRelay.this.log.warn("Missing DHCP relay server config. Abort packet processing");
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            if (packet == null) {
                return;
            }
            if (packet.getEtherType() == Ethernet.TYPE_IPV4) {
                IPv4 ipv4Packet = (IPv4)packet.getPayload();
                if (ipv4Packet.getProtocol() == 17) {
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    DHCP dhcpPayload = (DHCP)udpPacket.getPayload();
                    if (udpPacket.getSourcePort() == 68 || udpPacket.getSourcePort() == 67) {
                        this.processDhcpPacket(context, dhcpPayload);
                    }
                }
            } else if (packet.getEtherType() == Ethernet.TYPE_ARP && DhcpRelay.this.arpEnabled) {
                ARP arpPacket = (ARP)packet.getPayload();
                Set serverInterfaces = DhcpRelay.this.interfaceService.getInterfacesByPort(context.inPacket().receivedFrom());
                if (serverInterfaces.isEmpty()) {
                    DhcpRelay.this.log.warn("server virtual interface not configured");
                    return;
                }
                if (arpPacket.getOpCode() == 1 && this.checkArpRequestFrmDhcpServ(serverInterfaces, arpPacket)) {
                    this.processArpPacket(context, packet);
                }
            }
        }

        private boolean checkArpRequestFrmDhcpServ(Set<Interface> serverInterfaces, ARP arpPacket) {
            return Objects.equals(((InterfaceIpAddress)serverInterfaces.iterator().next().ipAddressesList().get(0)).ipAddress().getIp4Address(), Ip4Address.valueOf((byte[])arpPacket.getTargetProtocolAddress()));
        }

        private void forwardPacket(Ethernet packet) {
            if (DhcpRelay.this.dhcpServerConnectPoint != null) {
                TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(DhcpRelay.this.dhcpServerConnectPoint.port()).build();
                DefaultOutboundPacket o = new DefaultOutboundPacket(DhcpRelay.this.dhcpServerConnectPoint.deviceId(), t, ByteBuffer.wrap(packet.serialize()));
                if (DhcpRelay.this.log.isTraceEnabled()) {
                    DhcpRelay.this.log.trace("Relaying packet to dhcp server {}", (Object)packet);
                }
                DhcpRelay.this.packetService.emit((OutboundPacket)o);
            }
        }

        private void processArpPacket(PacketContext context, Ethernet packet) {
            ARP arpPacket = (ARP)packet.getPayload();
            ARP arpReply = (ARP)arpPacket.clone();
            arpReply.setOpCode((short)2);
            arpReply.setTargetProtocolAddress(arpPacket.getSenderProtocolAddress());
            arpReply.setTargetHardwareAddress(arpPacket.getSenderHardwareAddress());
            arpReply.setSenderProtocolAddress(arpPacket.getTargetProtocolAddress());
            arpReply.setSenderHardwareAddress(myMAC.toBytes());
            Ethernet ethReply = new Ethernet();
            ethReply.setSourceMACAddress(myMAC);
            ethReply.setDestinationMACAddress(packet.getSourceMAC());
            ethReply.setEtherType(Ethernet.TYPE_ARP);
            ethReply.setVlanID(packet.getVlanID());
            ethReply.setPayload((IPacket)arpReply);
            this.forwardPacket(ethReply);
        }

        private void processDhcpPacket(PacketContext context, DHCP dhcpPayload) {
            ConnectPoint inPort = context.inPacket().receivedFrom();
            Set clientServerInterfaces = DhcpRelay.this.interfaceService.getInterfacesByPort(inPort);
            if (clientServerInterfaces.isEmpty()) {
                DhcpRelay.this.log.warn("Virtual interface is not configured on {}", (Object)inPort);
                return;
            }
            if (dhcpPayload == null) {
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            DHCPPacketType incomingPacketType = null;
            for (DHCPOption option : dhcpPayload.getOptions()) {
                if (option.getCode() != DHCP.DHCPOptionCode.OptionCode_MessageType.getValue()) continue;
                byte[] data = option.getData();
                incomingPacketType = DHCPPacketType.getType((int)data[0]);
            }
            switch (incomingPacketType) {
                case DHCPDISCOVER: {
                    Ethernet ethernetPacketDiscover = this.processDhcpPacketFromClient(context, packet, clientServerInterfaces);
                    if (ethernetPacketDiscover == null) break;
                    this.forwardPacket(ethernetPacketDiscover);
                    break;
                }
                case DHCPOFFER: {
                    Ethernet ethernetPacketOffer = this.processDhcpPacketFromServer(packet);
                    if (ethernetPacketOffer == null) break;
                    this.sendReply(ethernetPacketOffer, dhcpPayload);
                    break;
                }
                case DHCPREQUEST: {
                    Ethernet ethernetPacketRequest = this.processDhcpPacketFromClient(context, packet, clientServerInterfaces);
                    if (ethernetPacketRequest == null) break;
                    this.forwardPacket(ethernetPacketRequest);
                    break;
                }
                case DHCPACK: {
                    Ethernet ethernetPacketAck = this.processDhcpPacketFromServer(packet);
                    if (ethernetPacketAck == null) break;
                    this.sendReply(ethernetPacketAck, dhcpPayload);
                    break;
                }
            }
        }

        private Ethernet processDhcpPacketFromClient(PacketContext context, Ethernet ethernetPacket, Set<Interface> clientInterfaces) {
            Ip4Address relayAgentIp = this.getRelayAgentIPv4Address(clientInterfaces);
            MacAddress relayAgentMac = clientInterfaces.iterator().next().mac();
            if (relayAgentIp == null || relayAgentMac == null) {
                DhcpRelay.this.log.warn("Missing DHCP relay agent interface Ipv4 addr config for packet from client on port: {}. Aborting packet processing", (Object)clientInterfaces.iterator().next().connectPoint());
                return null;
            }
            if (DhcpRelay.this.dhcpConnectMac == null) {
                DhcpRelay.this.log.warn("DHCP {} not yet resolved .. Aborting DHCP packet processing from client on port: {}", (Object)(DhcpRelay.this.dhcpGatewayIp == null ? "server IP " + DhcpRelay.this.dhcpServerIp : "gateway IP " + DhcpRelay.this.dhcpGatewayIp), (Object)clientInterfaces.iterator().next().connectPoint());
                return null;
            }
            Ethernet etherReply = (Ethernet)ethernetPacket.clone();
            etherReply.setSourceMACAddress(relayAgentMac);
            etherReply.setDestinationMACAddress(DhcpRelay.this.dhcpConnectMac);
            etherReply.setVlanID(DhcpRelay.this.dhcpConnectVlan.toShort());
            IPv4 ipv4Packet = (IPv4)etherReply.getPayload();
            ipv4Packet.setSourceAddress(relayAgentIp.toInt());
            ipv4Packet.setDestinationAddress(DhcpRelay.this.dhcpServerIp.toInt());
            UDP udpPacket = (UDP)ipv4Packet.getPayload();
            DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
            dhcpPacket.setGatewayIPAddress(relayAgentIp.toInt());
            udpPacket.setPayload((IPacket)dhcpPacket);
            ipv4Packet.setPayload((IPacket)udpPacket);
            etherReply.setPayload((IPacket)ipv4Packet);
            return etherReply;
        }

        private Ip4Address getRelayAgentIPv4Address(Set<Interface> intfs) {
            for (Interface intf : intfs) {
                for (InterfaceIpAddress ip : intf.ipAddressesList()) {
                    Ip4Address relayAgentIp = ip.ipAddress().getIp4Address();
                    if (relayAgentIp == null) continue;
                    return relayAgentIp;
                }
            }
            return null;
        }

        private Ethernet processDhcpPacketFromServer(Ethernet ethernetPacket) {
            Ethernet etherReply = (Ethernet)ethernetPacket.clone();
            IPv4 ipv4Packet = (IPv4)etherReply.getPayload();
            UDP udpPacket = (UDP)ipv4Packet.getPayload();
            DHCP dhcpPayload = (DHCP)udpPacket.getPayload();
            MacAddress dstMac = MacAddress.valueOf((byte[])dhcpPayload.getClientHardwareAddress());
            Set hosts = DhcpRelay.this.hostService.getHostsByMac(dstMac);
            if (hosts == null || hosts.isEmpty()) {
                DhcpRelay.this.log.warn("Cannot determine host for DHCP client: {}. Aborting relay for dhcp packet from server {}", (Object)dhcpPayload.getClientHardwareAddress(), (Object)ethernetPacket);
                return null;
            }
            if (hosts.size() > 1) {
                DhcpRelay.this.log.warn("Multiple hosts found for mac:{}. Picking one host out of {}", (Object)dstMac, (Object)hosts);
            }
            Host host = (Host)hosts.iterator().next();
            etherReply.setDestinationMACAddress(dstMac);
            etherReply.setVlanID(host.vlan().toShort());
            Ip4Address relayAgentIP = this.getRelayAgentIPv4Address(DhcpRelay.this.interfaceService.getInterfacesByPort((ConnectPoint)host.location()));
            if (relayAgentIP == null) {
                DhcpRelay.this.log.warn("Cannot determine relay agent interface Ipv4 addr for host {}. Aborting relay for dhcp packet from server {}", (Object)host, (Object)ethernetPacket);
                return null;
            }
            ipv4Packet.setSourceAddress(relayAgentIP.toInt());
            ipv4Packet.setDestinationAddress(dhcpPayload.getYourIPAddress());
            udpPacket.setDestinationPort(68);
            udpPacket.setPayload((IPacket)dhcpPayload);
            ipv4Packet.setPayload((IPacket)udpPacket);
            etherReply.setPayload((IPacket)ipv4Packet);
            return etherReply;
        }

        private void sendReply(Ethernet ethPacket, DHCP dhcpPayload) {
            MacAddress descMac = MacAddress.valueOf((byte[])dhcpPayload.getClientHardwareAddress());
            Host host = DhcpRelay.this.hostService.getHost(HostId.hostId((MacAddress)descMac, (VlanId)VlanId.vlanId((short)ethPacket.getVlanID())));
            if (host != null) {
                TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(host.location().port()).build();
                DefaultOutboundPacket o = new DefaultOutboundPacket(host.location().deviceId(), t, ByteBuffer.wrap(ethPacket.serialize()));
                if (DhcpRelay.this.log.isTraceEnabled()) {
                    DhcpRelay.this.log.trace("Relaying packet to dhcp client {}", (Object)ethPacket);
                }
                DhcpRelay.this.packetService.emit((OutboundPacket)o);
            }
        }
    }
}

