/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

public class ExtendedSet<E>
implements Set<E> {
    private final Map<E, E> map;

    public ExtendedSet(Map<E, E> map) {
        this.map = map;
    }

    public E get(Object o) {
        return this.map.get(o);
    }

    public boolean insertOrReplace(E entry, Predicate<E> entryTest) {
        AtomicBoolean updated = new AtomicBoolean(false);
        this.map.compute(Preconditions.checkNotNull(entry), (k, v) -> {
            if (v == null || entryTest.test(v)) {
                updated.set(true);
                return entry;
            }
            return v;
        });
        return updated.get();
    }

    public boolean conditionalRemove(E entry, Predicate<E> entryTest) {
        AtomicBoolean updated = new AtomicBoolean(false);
        this.map.compute(entry, (k, v) -> {
            if (entryTest.test(v)) {
                updated.set(true);
                return null;
            }
            return v;
        });
        return updated.get();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.map.entrySet().iterator(), Map.Entry::getValue);
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(e, e) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().map(this.map::containsKey).reduce(Boolean::logicalAnd).orElse(true);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(e -> this.map.putIfAbsent(e, e) == null).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return c.stream().filter(e -> !this.map.containsKey(e)).map(e -> this.map.remove(e) != null).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c.stream().map(e -> this.map.remove(e) != null).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

