/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.proxyarp;

import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv6;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.proxyarp.ProxyArpService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(enabled=false)
public class ProxyArp {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ProxyArpService proxyArpService;
    private ProxyArpProcessor processor = new ProxyArpProcessor();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private ApplicationId appId;
    @Property(name="ipv6NeighborDiscovery", boolValue={false}, label="Enable IPv6 Neighbor Discovery; default is false")
    protected boolean ipv6NeighborDiscovery = false;

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.proxyarp");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)1));
        this.readComponentConfiguration(context);
        this.requestPackets();
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.requestPackets();
    }

    private void requestPackets() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
        selectorBuilder.matchIPProtocol((byte)58);
        selectorBuilder.matchIcmpv6Type((byte)-121);
        if (this.ipv6NeighborDiscovery) {
            this.packetService.requestPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        }
        selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
        selectorBuilder.matchIPProtocol((byte)58);
        selectorBuilder.matchIcmpv6Type((byte)-120);
        if (this.ipv6NeighborDiscovery) {
            this.packetService.requestPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        }
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
        selectorBuilder.matchIPProtocol((byte)58);
        selectorBuilder.matchIcmpv6Type((byte)-121);
        this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
        selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
        selectorBuilder.matchIPProtocol((byte)58);
        selectorBuilder.matchIcmpv6Type((byte)-120);
        this.packetService.cancelPackets(selectorBuilder.build(), PacketPriority.CONTROL, this.appId);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"ipv6NeighborDiscovery");
        if (flag == null) {
            this.log.info("IPv6 Neighbor Discovery is not configured, using current value of {}", (Object)this.ipv6NeighborDiscovery);
        } else {
            this.ipv6NeighborDiscovery = flag;
            this.log.info("Configured. IPv6 Neighbor Discovery is {}", (Object)(this.ipv6NeighborDiscovery ? "enabled" : "disabled"));
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindProxyArpService(ProxyArpService proxyArpService) {
        this.proxyArpService = proxyArpService;
    }

    protected void unbindProxyArpService(ProxyArpService proxyArpService) {
        if (this.proxyArpService == proxyArpService) {
            this.proxyArpService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class ProxyArpProcessor
    implements PacketProcessor {
        private ProxyArpProcessor() {
        }

        public void process(PacketContext context) {
            ICMP6 icmp6Pkt;
            IPv6 ipv6Pkt;
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            if (ethPkt.getEtherType() == Ethernet.TYPE_ARP) {
                ProxyArp.this.proxyArpService.handlePacket(context);
            } else if (ProxyArp.this.ipv6NeighborDiscovery && ethPkt.getEtherType() == Ethernet.TYPE_IPV6 && (ipv6Pkt = (IPv6)ethPkt.getPayload()).getNextHeader() == 58 && ((icmp6Pkt = (ICMP6)ipv6Pkt.getPayload()).getIcmpType() == -121 || icmp6Pkt.getIcmpType() == -120)) {
                ProxyArp.this.proxyArpService.handlePacket(context);
            }
            if (ethPkt.getEtherType() == Ethernet.TYPE_IPV4 && ethPkt.getDestinationMAC().isMulticast()) {
                return;
            }
        }
    }
}

