/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.proxyarp;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.neighbour.DefaultNeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.edge.EdgePortEvent;
import org.onosproject.net.edge.EdgePortListener;
import org.onosproject.net.edge.EdgePortService;

@Component(immediate=true)
public class DefaultProxyArp {
    private static final String APP_NAME = "org.onosproject.proxyarp";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EdgePortService edgeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NeighbourResolutionService neighbourResolutionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ApplicationId appId;
    private InternalEdgeListener edgeListener = new InternalEdgeListener();
    private DefaultNeighbourMessageHandler defaultHandler = new DefaultNeighbourMessageHandler();

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.edgeService.addListener((EventListener)this.edgeListener);
        this.edgeService.getEdgePoints().forEach(this::addDefault);
    }

    @Deactivate
    protected void deactivate() {
        this.edgeService.removeListener((EventListener)this.edgeListener);
        this.neighbourResolutionService.unregisterNeighbourHandlers(this.appId);
    }

    private void addDefault(ConnectPoint port) {
        this.neighbourResolutionService.registerNeighbourHandler(port, (NeighbourMessageHandler)this.defaultHandler, this.appId);
    }

    private void removeDefault(ConnectPoint port) {
        this.neighbourResolutionService.unregisterNeighbourHandler(port, (NeighbourMessageHandler)this.defaultHandler, this.appId);
    }

    protected void bindEdgeService(EdgePortService edgePortService) {
        this.edgeService = edgePortService;
    }

    protected void unbindEdgeService(EdgePortService edgePortService) {
        if (this.edgeService == edgePortService) {
            this.edgeService = null;
        }
    }

    protected void bindNeighbourResolutionService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourResolutionService = neighbourResolutionService;
    }

    protected void unbindNeighbourResolutionService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourResolutionService == neighbourResolutionService) {
            this.neighbourResolutionService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalEdgeListener
    implements EdgePortListener {
        private InternalEdgeListener() {
        }

        public void event(EdgePortEvent event) {
            switch ((EdgePortEvent.Type)event.type()) {
                case EDGE_PORT_ADDED: {
                    DefaultProxyArp.this.addDefault((ConnectPoint)event.subject());
                    break;
                }
                case EDGE_PORT_REMOVED: {
                    DefaultProxyArp.this.removeDefault((ConnectPoint)event.subject());
                    break;
                }
            }
        }
    }
}

