/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.onosproject.tetopology.management.api.EncodingType;
import org.onosproject.tetopology.management.api.SwitchingType;
import org.onosproject.tetopology.management.api.node.LocalLinkConnectivity;
import org.onosproject.tetopology.management.api.node.TtpKey;
import org.onosproject.tetopology.management.api.node.TunnelTerminationPoint;

public class DefaultTunnelTerminationPoint
implements TunnelTerminationPoint {
    private final long ttpId;
    private final SwitchingType switchingLayer;
    private final EncodingType encodingLayer;
    private final BitSet flags;
    private final List<Long> interLayerLockList;
    private final List<LocalLinkConnectivity> localLinkConnectivityList;
    private final float[] availAdaptBandwidth;
    private final TtpKey supportTtpKey;

    public DefaultTunnelTerminationPoint(long ttpId, SwitchingType switchingLayer, EncodingType encodingLayer, BitSet flags, List<Long> interLayerLockList, List<LocalLinkConnectivity> localLinkConnectivityList, float[] availAdaptBandwidth, TtpKey supportTtpKey) {
        this.ttpId = ttpId;
        this.switchingLayer = switchingLayer;
        this.encodingLayer = encodingLayer;
        this.flags = flags;
        this.interLayerLockList = interLayerLockList != null ? Lists.newArrayList(interLayerLockList) : null;
        this.localLinkConnectivityList = localLinkConnectivityList != null ? Lists.newArrayList(localLinkConnectivityList) : null;
        this.availAdaptBandwidth = availAdaptBandwidth != null ? Arrays.copyOf(availAdaptBandwidth, availAdaptBandwidth.length) : null;
        this.supportTtpKey = supportTtpKey;
    }

    @Override
    public long ttpId() {
        return this.ttpId;
    }

    @Override
    public SwitchingType switchingLayer() {
        return this.switchingLayer;
    }

    @Override
    public EncodingType encodingLayer() {
        return this.encodingLayer;
    }

    @Override
    public BitSet flags() {
        return this.flags;
    }

    @Override
    public List<Long> interLayerLockList() {
        if (this.interLayerLockList == null) {
            return null;
        }
        return ImmutableList.copyOf(this.interLayerLockList);
    }

    @Override
    public List<LocalLinkConnectivity> localLinkConnectivityList() {
        if (this.localLinkConnectivityList == null) {
            return null;
        }
        return ImmutableList.copyOf(this.localLinkConnectivityList);
    }

    @Override
    public float[] availAdaptBandwidth() {
        if (this.availAdaptBandwidth == null) {
            return null;
        }
        return Arrays.copyOf(this.availAdaptBandwidth, this.availAdaptBandwidth.length);
    }

    @Override
    public TtpKey supportingTtpId() {
        return this.supportTtpKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ttpId, this.switchingLayer, this.encodingLayer, this.flags, this.interLayerLockList, this.localLinkConnectivityList, Arrays.hashCode(this.availAdaptBandwidth), this.supportTtpKey});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultTunnelTerminationPoint) {
            DefaultTunnelTerminationPoint that = (DefaultTunnelTerminationPoint)object;
            return Objects.equal((Object)this.ttpId, (Object)that.ttpId) && Objects.equal((Object)((Object)this.switchingLayer), (Object)((Object)that.switchingLayer)) && Objects.equal((Object)((Object)this.encodingLayer), (Object)((Object)that.encodingLayer)) && Objects.equal((Object)this.flags, (Object)that.flags) && Objects.equal(this.interLayerLockList, that.interLayerLockList) && Objects.equal(this.localLinkConnectivityList, that.localLinkConnectivityList) && Arrays.equals(this.availAdaptBandwidth, that.availAdaptBandwidth) && Objects.equal((Object)this.supportTtpKey, (Object)that.supportTtpKey);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ttpId", this.ttpId).add("switchingLayer", (Object)this.switchingLayer).add("encodingLayer", (Object)this.encodingLayer).add("flags", (Object)this.flags).add("interLayerLockList", this.interLayerLockList).add("localLinkConnectivityList", this.localLinkConnectivityList).add("availAdaptBandwidth", (Object)this.availAdaptBandwidth).add("supportTtpKey", (Object)this.supportTtpKey).toString();
    }
}

