/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.node.TerminationPoint;
import org.onosproject.tetopology.management.api.node.TerminationPointKey;

public class DefaultTerminationPoint
implements TerminationPoint {
    private final KeyId tpId;
    private final List<TerminationPointKey> supportingTpIds;
    private final Long teTpId;

    public DefaultTerminationPoint(KeyId tpId, List<TerminationPointKey> tps, Long teTpId) {
        this.tpId = tpId;
        this.supportingTpIds = tps != null ? Lists.newArrayList(tps) : null;
        this.teTpId = teTpId;
    }

    @Override
    public KeyId tpId() {
        return this.tpId;
    }

    @Override
    public Long teTpId() {
        return this.teTpId;
    }

    @Override
    public List<TerminationPointKey> supportingTpIds() {
        if (this.supportingTpIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.supportingTpIds);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tpId, this.supportingTpIds, this.teTpId});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultTerminationPoint) {
            DefaultTerminationPoint that = (DefaultTerminationPoint)object;
            return Objects.equal((Object)this.tpId, (Object)that.tpId) && Objects.equal(this.supportingTpIds, that.supportingTpIds) && Objects.equal((Object)this.teTpId, (Object)that.teTpId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tpId", (Object)this.tpId).add("supportingTpIds", this.supportingTpIds).add("teTpId", (Object)this.teTpId).toString();
    }
}

