/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.onosproject.tetopology.management.api.TeStatus;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.node.CommonNodeData;
import org.onosproject.tetopology.management.api.node.ConnectivityMatrix;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TunnelTerminationPoint;

public class DefaultTeNode
implements TeNode {
    private final long teNodeId;
    private final TeTopologyKey underlayTopologyId;
    private final TeNodeKey supportTeNodeId;
    private final TeNodeKey sourceTeNodeId;
    private final CommonNodeData teData;
    private final Map<Long, ConnectivityMatrix> connMatrices;
    private final List<Long> teLinkIds;
    private final Map<Long, TunnelTerminationPoint> ttps;
    private final List<Long> teTpIds;

    public DefaultTeNode(long teNodeId, TeTopologyKey underlayTopologyIdId, TeNodeKey supportTeNodeId, TeNodeKey sourceTeNodeId, CommonNodeData teData, Map<Long, ConnectivityMatrix> connMatrices, List<Long> teLinkIds, Map<Long, TunnelTerminationPoint> ttps, List<Long> teTpIds) {
        this.teNodeId = teNodeId;
        this.underlayTopologyId = underlayTopologyIdId;
        this.supportTeNodeId = supportTeNodeId;
        this.sourceTeNodeId = sourceTeNodeId;
        this.teData = teData;
        this.connMatrices = connMatrices != null ? Maps.newHashMap(connMatrices) : null;
        this.teLinkIds = teLinkIds != null ? Lists.newArrayList(teLinkIds) : null;
        this.ttps = ttps != null ? Maps.newHashMap(ttps) : null;
        this.teTpIds = teTpIds != null ? Lists.newArrayList(teTpIds) : null;
    }

    @Override
    public long teNodeId() {
        return this.teNodeId;
    }

    @Override
    public String name() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.name();
    }

    @Override
    public BitSet flags() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.flags();
    }

    @Override
    public TeTopologyKey underlayTeTopologyId() {
        return this.underlayTopologyId;
    }

    @Override
    public TeNodeKey supportingTeNodeId() {
        return this.supportTeNodeId;
    }

    @Override
    public TeNodeKey sourceTeNodeId() {
        return this.sourceTeNodeId;
    }

    @Override
    public Map<Long, ConnectivityMatrix> connectivityMatrices() {
        if (this.connMatrices == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.connMatrices);
    }

    @Override
    public ConnectivityMatrix connectivityMatrix(long entryId) {
        return this.connMatrices.get(entryId);
    }

    @Override
    public List<Long> teLinkIds() {
        if (this.teLinkIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.teLinkIds);
    }

    @Override
    public Map<Long, TunnelTerminationPoint> tunnelTerminationPoints() {
        if (this.ttps == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.ttps);
    }

    @Override
    public TunnelTerminationPoint tunnelTerminationPoint(long ttpId) {
        return this.ttps.get(ttpId);
    }

    @Override
    public TeStatus adminStatus() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.adminStatus();
    }

    @Override
    public TeStatus opStatus() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.opStatus();
    }

    @Override
    public List<Long> teTerminationPointIds() {
        return Collections.unmodifiableList(this.teTpIds);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teNodeId, this.underlayTopologyId, this.supportTeNodeId, this.sourceTeNodeId, this.teData, this.connMatrices, this.teLinkIds, this.ttps, this.teTpIds});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultTeNode) {
            DefaultTeNode that = (DefaultTeNode)object;
            return Objects.equal((Object)this.teNodeId, (Object)that.teNodeId) && Objects.equal((Object)this.underlayTopologyId, (Object)that.underlayTopologyId) && Objects.equal((Object)this.supportTeNodeId, (Object)that.supportTeNodeId) && Objects.equal((Object)this.sourceTeNodeId, (Object)that.sourceTeNodeId) && Objects.equal((Object)this.teData, (Object)that.teData) && Objects.equal(this.connMatrices, that.connMatrices) && Objects.equal(this.teLinkIds, that.teLinkIds) && Objects.equal(this.ttps, that.ttps) && Objects.equal(this.teTpIds, that.teTpIds);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teNodeId", this.teNodeId).add("underlayTopologyId", (Object)this.underlayTopologyId).add("supportTeNodeId", (Object)this.supportTeNodeId).add("sourceTeNodeId", (Object)this.sourceTeNodeId).add("teData", (Object)this.teData).add("connMatrices", this.connMatrices).add("teLinkIds", this.teLinkIds).add("ttps", this.ttps).add("teTpIds", this.teTpIds).toString();
    }
}

