/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.node.NetworkNode;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TerminationPoint;

public class DefaultNetworkNode
implements NetworkNode {
    private final KeyId id;
    private final List<NetworkNodeKey> supportingNodeIds;
    private final TeNode teNode;
    private final Map<KeyId, TerminationPoint> tps;

    public DefaultNetworkNode(KeyId id, List<NetworkNodeKey> nodeIds, TeNode teNode, Map<KeyId, TerminationPoint> tps) {
        this.id = id;
        this.supportingNodeIds = nodeIds != null ? Lists.newArrayList(nodeIds) : null;
        this.teNode = teNode;
        this.tps = tps != null ? Maps.newHashMap(tps) : null;
    }

    @Override
    public KeyId nodeId() {
        return this.id;
    }

    @Override
    public List<NetworkNodeKey> supportingNodeIds() {
        if (this.supportingNodeIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.supportingNodeIds);
    }

    @Override
    public TeNode teNode() {
        return this.teNode;
    }

    @Override
    public Map<KeyId, TerminationPoint> terminationPoints() {
        if (this.tps == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.tps);
    }

    @Override
    public TerminationPoint terminationPoint(KeyId tpId) {
        return this.tps.get(tpId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.supportingNodeIds, this.teNode, this.tps});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultNetworkNode) {
            DefaultNetworkNode that = (DefaultNetworkNode)object;
            return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.supportingNodeIds, that.supportingNodeIds) && Objects.equal((Object)this.teNode, (Object)that.teNode) && Objects.equal(this.tps, that.tps);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("supportingNodeIds", this.supportingNodeIds).add("teNode", (Object)this.teNode).add("tps", this.tps).toString();
    }
}

