/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import org.onosproject.tetopology.management.api.link.ElementType;
import org.onosproject.tetopology.management.api.link.TePathAttributes;
import org.onosproject.tetopology.management.api.link.UnderlayAbstractPath;
import org.onosproject.tetopology.management.api.node.AbstractConnectivity;

public class ConnectivityMatrix
extends AbstractConnectivity {
    public static final short BIT_DISALLOWED = 0;
    public static final short BIT_ALTERNATIVE_PATH_AVAILABLE = 1;
    public static final short BIT_DISABLED = 2;
    private final long key;
    private final ElementType from;
    private final List<ElementType> mergingList;

    public ConnectivityMatrix(long key, ElementType from, List<ElementType> mergingList, List<ElementType> constrainingElements, BitSet flags, TePathAttributes teAttributes, UnderlayAbstractPath underlayPath) {
        super(constrainingElements, flags, teAttributes, underlayPath);
        this.key = key;
        this.from = from;
        this.mergingList = mergingList != null ? Lists.newArrayList(mergingList) : null;
    }

    public long key() {
        return this.key;
    }

    public ElementType from() {
        return this.from;
    }

    public List<ElementType> mergingList() {
        if (this.mergingList == null) {
            return null;
        }
        return ImmutableList.copyOf(this.mergingList);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.from, this.mergingList, super.hashCode()});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ConnectivityMatrix) {
            if (!super.equals(object)) {
                return false;
            }
            ConnectivityMatrix that = (ConnectivityMatrix)object;
            return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.from, (Object)that.from) && Objects.equal(this.mergingList, that.mergingList);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("from", (Object)this.from).add("mergingList", this.mergingList).add("constrainingElements", this.constrainingElements()).add("flags", (Object)this.flags()).add("teAttributes", (Object)this.teAttributes()).toString();
    }
}

