/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.onosproject.tetopology.management.api.link.ElementType;
import org.onosproject.tetopology.management.api.link.TePathAttributes;
import org.onosproject.tetopology.management.api.link.UnderlayAbstractPath;

public class AbstractConnectivity {
    private final List<ElementType> constrainingElements;
    private final BitSet flags;
    private final TePathAttributes teAttributes;
    private final UnderlayAbstractPath underlayPath;

    public AbstractConnectivity(List<ElementType> constrainingElements, BitSet flags, TePathAttributes teAttributes, UnderlayAbstractPath underlayPath) {
        this.constrainingElements = Lists.newArrayList(constrainingElements);
        this.flags = flags;
        this.teAttributes = teAttributes;
        this.underlayPath = underlayPath;
    }

    public List<ElementType> constrainingElements() {
        return Collections.unmodifiableList(this.constrainingElements);
    }

    public BitSet flags() {
        return this.flags;
    }

    public TePathAttributes teAttributes() {
        return this.teAttributes;
    }

    public UnderlayAbstractPath underlayPath() {
        return this.underlayPath;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.constrainingElements, this.flags, this.teAttributes, this.underlayPath});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractConnectivity) {
            AbstractConnectivity that = (AbstractConnectivity)object;
            return Objects.equal(this.constrainingElements, that.constrainingElements) && Objects.equal((Object)this.flags, (Object)that.flags) && Objects.equal((Object)this.teAttributes, (Object)that.teAttributes) && Objects.equal((Object)this.underlayPath, (Object)that.underlayPath);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("constrainingElements", this.constrainingElements).add("flags", (Object)this.flags).add("teAttributes", (Object)this.teAttributes).add("underlayPath", (Object)this.underlayPath).toString();
    }
}

