/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeTunnelId;
import org.onosproject.tetopology.management.api.link.TunnelProtectionType;
import org.onosproject.tetopology.management.api.link.UnderlayBackupPath;
import org.onosproject.tetopology.management.api.link.UnderlayPrimaryPath;

public class UnderlayPath {
    private final UnderlayPrimaryPath primaryPath;
    private final List<UnderlayBackupPath> backupPaths;
    private final TunnelProtectionType tunnelProtectionType;
    private final long srcTtpId;
    private final long dstTtpId;
    private final TeTunnelId teTunnelId;

    public UnderlayPath(UnderlayPrimaryPath primaryPath, List<UnderlayBackupPath> backupPaths, TunnelProtectionType tunnelProtectionType, long srcTtpId, long dstTtpId, TeTunnelId teTunnelId) {
        this.primaryPath = primaryPath;
        this.backupPaths = backupPaths != null ? Lists.newArrayList(backupPaths) : null;
        this.tunnelProtectionType = tunnelProtectionType;
        this.srcTtpId = srcTtpId;
        this.dstTtpId = dstTtpId;
        this.teTunnelId = teTunnelId;
    }

    public UnderlayPath(TeLink link) {
        this.primaryPath = link.primaryPath();
        this.backupPaths = link.backupPaths() != null ? Lists.newArrayList(link.backupPaths()) : null;
        this.tunnelProtectionType = link.tunnelProtectionType();
        this.srcTtpId = link.sourceTtpId();
        this.dstTtpId = link.destinationTtpId();
        this.teTunnelId = link.teTunnelId();
    }

    public UnderlayPrimaryPath primaryPath() {
        return this.primaryPath;
    }

    public List<UnderlayBackupPath> backupPaths() {
        if (this.backupPaths == null) {
            return null;
        }
        return ImmutableList.copyOf(this.backupPaths);
    }

    public TunnelProtectionType tunnelProtectionType() {
        return this.tunnelProtectionType;
    }

    public long srcTtpId() {
        return this.srcTtpId;
    }

    public long dstTtpId() {
        return this.dstTtpId;
    }

    public TeTunnelId teTunnelId() {
        return this.teTunnelId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.primaryPath, this.backupPaths, this.tunnelProtectionType, this.srcTtpId, this.dstTtpId, this.teTunnelId});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UnderlayPath) {
            UnderlayPath that = (UnderlayPath)object;
            return Objects.equal((Object)this.primaryPath, (Object)that.primaryPath) && Objects.equal(this.backupPaths, that.backupPaths) && Objects.equal((Object)((Object)this.tunnelProtectionType), (Object)((Object)that.tunnelProtectionType)) && Objects.equal((Object)this.srcTtpId, (Object)that.srcTtpId) && Objects.equal((Object)this.dstTtpId, (Object)that.dstTtpId) && Objects.equal((Object)this.teTunnelId, (Object)that.teTunnelId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("primaryPath", (Object)this.primaryPath).add("backupPaths", this.backupPaths).add("tunnelProtectionType", (Object)this.tunnelProtectionType).add("srcTtpId", this.srcTtpId).add("dstTtpId", this.dstTtpId).add("teTunnelId", (Object)this.teTunnelId).toString();
    }
}

