/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

public enum TunnelProtectionType {
    UNPROTECTED(0),
    EXTRA_TRAFFIC(1),
    SHARED(2),
    ONE_FOR_ONE(3),
    ONE_PLUS_ONE(4),
    ENHANCED(5);

    private int value;

    private TunnelProtectionType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static TunnelProtectionType of(String s) {
        try {
            int tmpVal = Integer.parseInt(s);
            return TunnelProtectionType.of(tmpVal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static TunnelProtectionType of(int value) {
        switch (value) {
            case 0: {
                return UNPROTECTED;
            }
            case 1: {
                return EXTRA_TRAFFIC;
            }
            case 2: {
                return SHARED;
            }
            case 3: {
                return ONE_FOR_ONE;
            }
            case 4: {
                return ONE_PLUS_ONE;
            }
            case 5: {
                return ENHANCED;
            }
        }
        return null;
    }
}

