/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.link.TeLink;

public class TePathAttributes {
    private final Long cost;
    private final Long delay;
    private final List<Long> srlgs;

    public TePathAttributes(Long cost, Long delay, List<Long> srlgs) {
        this.cost = cost;
        this.delay = delay;
        this.srlgs = srlgs != null ? Lists.newArrayList(srlgs) : null;
    }

    public TePathAttributes(TeLink link) {
        this.cost = link.cost();
        this.delay = link.delay();
        this.srlgs = link.srlgs() != null ? Lists.newArrayList(link.srlgs()) : null;
    }

    public Long cost() {
        return this.cost;
    }

    public Long delay() {
        return this.delay;
    }

    public List<Long> srlgs() {
        if (this.srlgs == null) {
            return null;
        }
        return ImmutableList.copyOf(this.srlgs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cost, this.delay, this.srlgs});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TePathAttributes) {
            TePathAttributes that = (TePathAttributes)object;
            return Objects.equal((Object)this.cost, (Object)that.cost) && Objects.equal((Object)this.delay, (Object)that.delay) && Objects.equal(this.srlgs, that.srlgs);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("cost", (Object)this.cost).add("delay", (Object)this.delay).add("srlgs", this.srlgs).toString();
    }
}

