/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.Ip6Address;
import org.onosproject.tetopology.management.api.link.ElementType;

public class TeIpv6
implements ElementType {
    private final Ip6Address v6Address;
    private final short v6PrefixLength;

    public TeIpv6(Ip6Address v6Address, short v6PrefixLength) {
        this.v6Address = v6Address;
        this.v6PrefixLength = v6PrefixLength;
    }

    public Ip6Address v6Address() {
        return this.v6Address;
    }

    public short v6PrefixLength() {
        return this.v6PrefixLength;
    }

    public int hashCode() {
        return Objects.hash(this.v6Address, this.v6PrefixLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeIpv6) {
            TeIpv6 other = (TeIpv6)obj;
            return Objects.equals(this.v6Address, other.v6Address) && Objects.equals(this.v6PrefixLength, other.v6PrefixLength);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("v6Address", (Object)this.v6Address).add("v6PrefixLength", (int)this.v6PrefixLength).toString();
    }
}

