/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.onosproject.tetopology.management.api.link.OduResource;
import org.onosproject.tetopology.management.api.link.TeLink;

public class LinkBandwidth {
    private final float[] maxBandwidth;
    private final float[] availBandwidth;
    private final float[] maxAvailLspBandwidth;
    private final float[] minAvailLspBandwidth;
    private final OduResource odu;

    public LinkBandwidth(float[] maxBandwidth, float[] availBandwidth, float[] maxAvailLspBandwidth, float[] minAvailLspBandwidth, OduResource odu) {
        this.maxBandwidth = maxBandwidth != null ? Arrays.copyOf(maxBandwidth, maxBandwidth.length) : null;
        this.availBandwidth = availBandwidth != null ? Arrays.copyOf(availBandwidth, availBandwidth.length) : null;
        this.maxAvailLspBandwidth = maxAvailLspBandwidth != null ? Arrays.copyOf(maxAvailLspBandwidth, maxAvailLspBandwidth.length) : null;
        this.minAvailLspBandwidth = minAvailLspBandwidth != null ? Arrays.copyOf(minAvailLspBandwidth, minAvailLspBandwidth.length) : null;
        this.odu = odu;
    }

    public LinkBandwidth(TeLink link) {
        this.maxBandwidth = link.maxBandwidth();
        this.availBandwidth = link.maxAvailLspBandwidth();
        this.maxAvailLspBandwidth = link.maxAvailLspBandwidth();
        this.minAvailLspBandwidth = link.minAvailLspBandwidth();
        this.odu = link.oduResource();
    }

    public float[] maxBandwidth() {
        if (this.maxBandwidth == null) {
            return null;
        }
        return Arrays.copyOf(this.maxBandwidth, this.maxBandwidth.length);
    }

    public float[] availBandwidth() {
        if (this.availBandwidth == null) {
            return null;
        }
        return Arrays.copyOf(this.availBandwidth, this.availBandwidth.length);
    }

    public float[] maxAvailLspBandwidth() {
        if (this.maxAvailLspBandwidth == null) {
            return null;
        }
        return Arrays.copyOf(this.maxAvailLspBandwidth, this.maxAvailLspBandwidth.length);
    }

    public float[] minAvailLspBandwidth() {
        if (this.minAvailLspBandwidth == null) {
            return null;
        }
        return Arrays.copyOf(this.minAvailLspBandwidth, this.minAvailLspBandwidth.length);
    }

    public OduResource oduResource() {
        return this.odu;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.maxBandwidth), Arrays.hashCode(this.availBandwidth), Arrays.hashCode(this.maxAvailLspBandwidth), Arrays.hashCode(this.minAvailLspBandwidth), this.odu});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LinkBandwidth) {
            LinkBandwidth that = (LinkBandwidth)object;
            return Arrays.equals(this.maxBandwidth, that.maxBandwidth) && Arrays.equals(this.availBandwidth, that.availBandwidth) && Arrays.equals(this.maxAvailLspBandwidth, that.maxAvailLspBandwidth) && Arrays.equals(this.minAvailLspBandwidth, that.minAvailLspBandwidth) && Objects.equal((Object)this.odu, (Object)that.odu);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxBandwidth", (Object)this.maxBandwidth).add("availBandwidth", (Object)this.availBandwidth).add("maxAvailLspBandwidth", (Object)this.maxAvailLspBandwidth).add("minAvailLspBandwidth", (Object)this.minAvailLspBandwidth).add("odu", (Object)this.odu).toString();
    }
}

