/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.BitSet;
import java.util.List;
import org.onosproject.tetopology.management.api.EncodingType;
import org.onosproject.tetopology.management.api.SwitchingType;
import org.onosproject.tetopology.management.api.TeStatus;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.link.CommonLinkData;
import org.onosproject.tetopology.management.api.link.ExternalLink;
import org.onosproject.tetopology.management.api.link.OduResource;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.link.TeTunnelId;
import org.onosproject.tetopology.management.api.link.TunnelProtectionType;
import org.onosproject.tetopology.management.api.link.UnderlayBackupPath;
import org.onosproject.tetopology.management.api.link.UnderlayPrimaryPath;

public class DefaultTeLink
implements TeLink {
    private final TeLinkTpKey teLinkKey;
    private final TeLinkTpKey peerTeLinkKey;
    private final TeTopologyKey underlayTopologyId;
    private final TeLinkTpGlobalKey supportTeLinkId;
    private final TeLinkTpGlobalKey sourceTeLinkId;
    private final CommonLinkData teData;

    public DefaultTeLink(TeLinkTpKey teLinkKey, TeLinkTpKey peerTeLinkKey, TeTopologyKey underlayTopologyId, TeLinkTpGlobalKey supportTeLinkId, TeLinkTpGlobalKey sourceTeLinkId, CommonLinkData teData) {
        this.teLinkKey = teLinkKey;
        this.peerTeLinkKey = peerTeLinkKey;
        this.underlayTopologyId = underlayTopologyId;
        this.supportTeLinkId = supportTeLinkId;
        this.sourceTeLinkId = sourceTeLinkId;
        this.teData = teData;
    }

    @Override
    public TeLinkTpKey teLinkKey() {
        return this.teLinkKey;
    }

    @Override
    public TeLinkTpKey peerTeLinkKey() {
        return this.peerTeLinkKey;
    }

    @Override
    public BitSet flags() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.flags();
    }

    @Override
    public SwitchingType switchingLayer() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.switchingLayer();
    }

    @Override
    public EncodingType encodingLayer() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.encodingLayer();
    }

    @Override
    public ExternalLink externalLink() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.externalLink();
    }

    @Override
    public TeTopologyKey underlayTeTopologyId() {
        return this.underlayTopologyId;
    }

    @Override
    public UnderlayPrimaryPath primaryPath() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return null;
        }
        return this.teData.underlayPath().primaryPath();
    }

    @Override
    public List<UnderlayBackupPath> backupPaths() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return null;
        }
        return this.teData.underlayPath().backupPaths();
    }

    @Override
    public TunnelProtectionType tunnelProtectionType() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return null;
        }
        return this.teData.underlayPath().tunnelProtectionType();
    }

    @Override
    public long sourceTtpId() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return 0L;
        }
        return this.teData.underlayPath().srcTtpId();
    }

    @Override
    public long destinationTtpId() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return 0L;
        }
        return this.teData.underlayPath().dstTtpId();
    }

    @Override
    public TeTunnelId teTunnelId() {
        if (this.teData == null || this.teData.underlayPath() == null) {
            return null;
        }
        return this.teData.underlayPath().teTunnelId();
    }

    @Override
    public TeLinkTpGlobalKey supportingTeLinkId() {
        return this.supportTeLinkId;
    }

    @Override
    public TeLinkTpGlobalKey sourceTeLinkId() {
        return this.sourceTeLinkId;
    }

    @Override
    public Long cost() {
        if (this.teData == null || this.teData.teAttributes() == null) {
            return 0L;
        }
        return this.teData.teAttributes().cost();
    }

    @Override
    public Long delay() {
        if (this.teData == null || this.teData.teAttributes() == null) {
            return 0L;
        }
        return this.teData.teAttributes().delay();
    }

    @Override
    public List<Long> srlgs() {
        if (this.teData == null || this.teData.teAttributes() == null) {
            return null;
        }
        return this.teData.teAttributes().srlgs();
    }

    @Override
    public Long administrativeGroup() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.adminGroup();
    }

    @Override
    public List<Long> interLayerLocks() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.interLayerLocks();
    }

    @Override
    public float[] maxBandwidth() {
        if (this.teData == null || this.teData.bandwidth() == null) {
            return null;
        }
        return this.teData.bandwidth().maxBandwidth();
    }

    @Override
    public float[] availBandwidth() {
        if (this.teData == null || this.teData.bandwidth() == null) {
            return null;
        }
        return this.teData.bandwidth().availBandwidth();
    }

    @Override
    public float[] maxAvailLspBandwidth() {
        if (this.teData == null || this.teData.bandwidth() == null) {
            return null;
        }
        return this.teData.bandwidth().maxAvailLspBandwidth();
    }

    @Override
    public float[] minAvailLspBandwidth() {
        if (this.teData == null || this.teData.bandwidth() == null) {
            return null;
        }
        return this.teData.bandwidth().minAvailLspBandwidth();
    }

    @Override
    public OduResource oduResource() {
        if (this.teData == null || this.teData.bandwidth() == null) {
            return null;
        }
        return this.teData.bandwidth().oduResource();
    }

    @Override
    public TeStatus adminStatus() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.adminStatus();
    }

    @Override
    public TeStatus opStatus() {
        if (this.teData == null) {
            return null;
        }
        return this.teData.opStatus();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teLinkKey, this.peerTeLinkKey, this.underlayTopologyId, this.supportTeLinkId, this.sourceTeLinkId, this.teData});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultTeLink) {
            DefaultTeLink that = (DefaultTeLink)object;
            return Objects.equal((Object)this.teLinkKey, (Object)that.teLinkKey) && Objects.equal((Object)this.peerTeLinkKey, (Object)that.peerTeLinkKey) && Objects.equal((Object)this.underlayTopologyId, (Object)that.underlayTopologyId) && Objects.equal((Object)this.supportTeLinkId, (Object)that.supportTeLinkId) && Objects.equal((Object)this.sourceTeLinkId, (Object)that.sourceTeLinkId) && Objects.equal((Object)this.teData, (Object)that.teData);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teLinkKey", (Object)this.teLinkKey).add("peerTeLinkKey", (Object)this.peerTeLinkKey).add("underlayTopologyId", (Object)this.underlayTopologyId).add("supportTeLinkId", (Object)this.supportTeLinkId).add("sourceTeLinkId", (Object)this.sourceTeLinkId).add("teData", (Object)this.teData).toString();
    }
}

