/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.node.NodeTpKey;

public class DefaultNetworkLink
implements NetworkLink {
    private final KeyId linkId;
    private final NodeTpKey source;
    private final NodeTpKey destination;
    private final List<NetworkLinkKey> supportingLinkIds;
    private final TeLink teLink;

    public DefaultNetworkLink(KeyId linkId, NodeTpKey source, NodeTpKey destination, List<NetworkLinkKey> supportingLinkIds, TeLink teLink) {
        this.linkId = linkId;
        this.source = source;
        this.destination = destination;
        this.supportingLinkIds = supportingLinkIds != null ? Lists.newArrayList(supportingLinkIds) : null;
        this.teLink = teLink;
    }

    @Override
    public KeyId linkId() {
        return this.linkId;
    }

    @Override
    public NodeTpKey source() {
        return this.source;
    }

    @Override
    public NodeTpKey destination() {
        return this.destination;
    }

    @Override
    public List<NetworkLinkKey> supportingLinkIds() {
        if (this.supportingLinkIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.supportingLinkIds);
    }

    @Override
    public TeLink teLink() {
        return this.teLink;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.linkId, this.source, this.destination, this.supportingLinkIds, this.teLink});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultNetworkLink) {
            DefaultNetworkLink that = (DefaultNetworkLink)object;
            return Objects.equal((Object)this.linkId, (Object)that.linkId) && Objects.equal((Object)this.source, (Object)that.source) && Objects.equal((Object)this.destination, (Object)that.destination) && Objects.equal(this.supportingLinkIds, that.supportingLinkIds) && Objects.equal((Object)this.teLink, (Object)that.teLink);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("linkId", (Object)this.linkId).add("source", (Object)this.source).add("destination", (Object)this.destination).add("supportingLinkIds", this.supportingLinkIds).add("teLink", (Object)this.teLink).toString();
    }
}

