/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import org.onosproject.tetopology.management.api.EncodingType;
import org.onosproject.tetopology.management.api.SwitchingType;
import org.onosproject.tetopology.management.api.TeStatus;
import org.onosproject.tetopology.management.api.link.ExternalLink;
import org.onosproject.tetopology.management.api.link.LinkBandwidth;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TePathAttributes;
import org.onosproject.tetopology.management.api.link.UnderlayPath;

public class CommonLinkData {
    private final TeStatus adminStatus;
    private final TeStatus opStatus;
    private final BitSet flags;
    private final SwitchingType switchingLayer;
    private final EncodingType encodingLayer;
    private final ExternalLink externalLink;
    private final UnderlayPath underlayPath;
    private final TePathAttributes teAttributes;
    private final List<Long> interLayerLocks;
    private final LinkBandwidth bandwidth;
    private final Long adminGroup;

    public CommonLinkData(TeStatus adminStatus, TeStatus opStatus, BitSet flags, SwitchingType switchingLayer, EncodingType encodingLayer, ExternalLink externalLink, UnderlayPath underlayPath, TePathAttributes teAttributes, Long adminGroup, List<Long> interLayerLocks, LinkBandwidth bandwidth) {
        this.adminStatus = adminStatus;
        this.opStatus = opStatus;
        this.flags = flags;
        this.switchingLayer = switchingLayer;
        this.encodingLayer = encodingLayer;
        this.externalLink = externalLink;
        this.underlayPath = underlayPath;
        this.teAttributes = teAttributes;
        this.adminGroup = adminGroup;
        this.interLayerLocks = interLayerLocks != null ? Lists.newArrayList(interLayerLocks) : null;
        this.bandwidth = bandwidth;
    }

    public CommonLinkData(TeLink link) {
        this.adminStatus = link.adminStatus();
        this.opStatus = link.opStatus();
        this.flags = link.flags();
        this.switchingLayer = link.switchingLayer();
        this.encodingLayer = link.encodingLayer();
        this.externalLink = link.externalLink();
        this.underlayPath = new UnderlayPath(link);
        this.teAttributes = new TePathAttributes(link);
        this.adminGroup = link.administrativeGroup();
        this.interLayerLocks = link.interLayerLocks() != null ? Lists.newArrayList(link.interLayerLocks()) : null;
        this.bandwidth = new LinkBandwidth(link);
    }

    public TeStatus adminStatus() {
        return this.adminStatus;
    }

    public TeStatus opStatus() {
        return this.opStatus;
    }

    public BitSet flags() {
        return this.flags;
    }

    public SwitchingType switchingLayer() {
        return this.switchingLayer;
    }

    public EncodingType encodingLayer() {
        return this.encodingLayer;
    }

    public ExternalLink externalLink() {
        return this.externalLink;
    }

    public UnderlayPath underlayPath() {
        return this.underlayPath;
    }

    public TePathAttributes teAttributes() {
        return this.teAttributes;
    }

    public Long adminGroup() {
        return this.adminGroup;
    }

    public List<Long> interLayerLocks() {
        if (this.interLayerLocks == null) {
            return null;
        }
        return ImmutableList.copyOf(this.interLayerLocks);
    }

    public LinkBandwidth bandwidth() {
        return this.bandwidth;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.adminStatus, this.opStatus, this.flags, this.switchingLayer, this.encodingLayer, this.externalLink, this.underlayPath, this.teAttributes, this.interLayerLocks, this.bandwidth});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CommonLinkData) {
            CommonLinkData that = (CommonLinkData)object;
            return Objects.equal((Object)((Object)this.adminStatus), (Object)((Object)that.adminStatus)) && Objects.equal((Object)((Object)this.opStatus), (Object)((Object)that.opStatus)) && Objects.equal((Object)this.flags, (Object)that.flags) && Objects.equal((Object)((Object)this.switchingLayer), (Object)((Object)that.switchingLayer)) && Objects.equal((Object)((Object)this.encodingLayer), (Object)((Object)that.encodingLayer)) && Objects.equal((Object)this.externalLink, (Object)that.externalLink) && Objects.equal((Object)this.underlayPath, (Object)that.underlayPath) && Objects.equal((Object)this.teAttributes, (Object)that.teAttributes) && Objects.equal(this.interLayerLocks, that.interLayerLocks) && Objects.equal((Object)this.bandwidth, (Object)that.bandwidth);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("adminStatus", (Object)this.adminStatus).add("opStatus", (Object)this.opStatus).add("flags", (Object)this.flags).add("switchingLayer", (Object)this.switchingLayer).add("encodingLayer", (Object)this.encodingLayer).add("externalLink", (Object)this.externalLink).add("underlayPath", (Object)this.underlayPath).add("teAttributes", (Object)this.teAttributes).add("interLayerLocks", this.interLayerLocks).add("bandwidth", (Object)this.bandwidth).toString();
    }
}

