/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Map;
import org.onosproject.net.DeviceId;
import org.onosproject.tetopology.management.api.CommonTopologyData;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.OptimizationType;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.node.TeNode;

public class DefaultTeTopology
implements TeTopology {
    private final TeTopologyKey teKey;
    private final Map<Long, TeNode> teNodes;
    private final Map<TeLinkTpKey, TeLink> teLinks;
    private final String idString;
    private final CommonTopologyData common;

    public DefaultTeTopology(TeTopologyKey teKey, Map<Long, TeNode> teNodes, Map<TeLinkTpKey, TeLink> teLinks, String idString, CommonTopologyData common) {
        this.teKey = teKey;
        this.teNodes = teNodes != null ? Maps.newHashMap(teNodes) : null;
        this.teLinks = teLinks != null ? Maps.newHashMap(teLinks) : null;
        this.idString = idString;
        this.common = common;
    }

    @Override
    public TeTopologyKey teTopologyId() {
        return this.teKey;
    }

    @Override
    public BitSet flags() {
        if (this.common == null) {
            return null;
        }
        return this.common.flags();
    }

    @Override
    public OptimizationType optimization() {
        if (this.common == null) {
            return null;
        }
        return this.common.optimization();
    }

    @Override
    public Map<Long, TeNode> teNodes() {
        if (this.teNodes == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.teNodes);
    }

    @Override
    public TeNode teNode(long teNodeId) {
        return this.teNodes.get(teNodeId);
    }

    @Override
    public Map<TeLinkTpKey, TeLink> teLinks() {
        if (this.teLinks == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.teLinks);
    }

    @Override
    public TeLink teLink(TeLinkTpKey teLinkId) {
        return this.teLinks.get(teLinkId);
    }

    @Override
    public String teTopologyIdStringValue() {
        return this.idString;
    }

    @Override
    public KeyId networkId() {
        if (this.common == null) {
            return null;
        }
        return this.common.networkId();
    }

    @Override
    public DeviceId ownerId() {
        if (this.common == null) {
            return null;
        }
        return this.common.ownerId();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teKey, this.teNodes, this.teLinks, this.common, this.idString});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultTeTopology) {
            DefaultTeTopology that = (DefaultTeTopology)object;
            return Objects.equal((Object)this.teKey, (Object)that.teKey) && Objects.equal(this.teNodes, that.teNodes) && Objects.equal(this.teLinks, that.teLinks) && Objects.equal((Object)this.common, (Object)that.common) && Objects.equal((Object)this.idString, (Object)that.idString);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teKey", (Object)this.teKey).add("teNodes", this.teNodes).add("teLinks", this.teLinks).add("common", (Object)this.common).add("idString", (Object)this.idString).toString();
    }
}

